% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incidence.from.congress.R
\name{incidence.from.congress}
\alias{incidence.from.congress}
\title{Generate bill sponsorship incidence matrices and bipartite graphs}
\usage{
incidence.from.congress(
  session = NULL,
  types = NULL,
  areas = "All",
  nonvoting = FALSE,
  weighted = FALSE,
  format = "data",
  narrative = FALSE
)
}
\arguments{
\item{session}{numeric: the session of congress}

\item{types}{vector: types of bills to include. May be any combination of c("s", "sres", "sjres", "sconres") OR any combination of c("hr", "hres", "hjres", "hconres").}

\item{areas}{string: policy areas of bills to include (see details)}

\item{nonvoting}{boolean: should non-voting members be included}

\item{weighted}{boolean: should sponsor-bill edges have a weight of 2, but cosponsor-bill edges have a weight of 1}

\item{format}{string: format of output, one of c("data", "igraph")}

\item{narrative}{boolean: TRUE if suggested text & citations should be displayed.}
}
\value{
If \code{format = "data"}, a list containing an incidence matrix, a dataframe of legislator characteristics, and a dataframe of bill characteristics.

If \code{format = "igraph"}, a bipartite igraph object composed of legislator vertices and bill vertices, each with vertex attributes.
}
\description{
\code{incidence.from.congress()} uses data from \href{https://www.congress.gov/}{https://www.congress.gov/} to construct an incidence
matrix or bipartite graph recording legislators' bill (co-)sponsorships.
}
\details{
The \code{incidence.from.congress()} function uses data from \href{https://www.congress.gov/}{https://www.congress.gov/} to
construct an incidence matrix or bipartite graph recording legislators' bill (co-)sponsorships. In an incidence matrix
\strong{I}, entry \emph{Iik = 1} if legislator \emph{i} sponsored or co-sponsored bill \emph{k}, and otherwise is 0. In a bipartite graph
\strong{G}, a legislator \emph{i} is connected to a bill \emph{k} if \emph{i} sponsored or co-sponsored \emph{k}.

In the US Congress, the law making process begins when a \emph{sponsor} legislator introduces a bill in their chamber (House of
Representatives or Senate). Additional legislators in the same chamber can support the bill by joining as a \emph{co-sponsor}.
The bill is discussed, revised, and possibly voted on in the chamber. If it passes in one chamber, it is sent to the other
chamber for further discussion, revision, and possibly a vote. If it passed both chambers, it is sent to the President. If
the President signs the bill, it becomes law.

In the House of Representatives, legislators can introduce four types of bills: a House Bill (hb), a House Joint Resolution (hjres),
a House Concurrent Resolution (hconres), and a House Simple Resolution (hres). Similarly, in the Senate, legislators can introduce
four types of bills: a Senate Bill (s), a Senate Joint Resolution (sjres), a Senate Concurrent Resolution (sconres), and a Senate
Simple Resolution (sres). In both chambers, concurrent and simple resolutions are used for minor procedural matters and do not
have the force of law. Only bills and joint resolutions require the President's signature and have the force of law if signed.

Each bill is assigned a policy area by the Congressional Research Service. By default, bills from all policy areas are included,
however the \code{areas} parameter can be used to include only bills addressing certain policy areas. The \code{areas} takes a vector of
strings listing the desired policy areas (e.g., \code{areas = c("Congress", "Animals")}). Policy area names are \strong{case-sensitive}. A
complete list of policy areas and brief descriptions is available at \href{https://www.congress.gov/help/field-values/policy-area}{https://www.congress.gov/help/field-values/policy-area}.
}
\examples{
\dontrun{
D <- incidence.from.congress(session = 116, types = "s", format = "data")
D <- incidence.from.congress(session = 116, types = "s", format = "data", areas = "Animals")
G <- incidence.from.congress(session = 115, types = c("hr", "hres"), format = "igraph")
}
}
\references{


{Neal, Z. P. 2022. incidentally: An R package to generate incidence matrices and bipartite graphs. \emph{OSF Preprints} \doi{10.31219/osf.io/ectms}}
}
