% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flextable-getListing.R
\name{createFlextableWithHeader}
\alias{createFlextableWithHeader}
\title{Create a flextable, setting the column names to syntactic names
if it is not the case.}
\usage{
createFlextableWithHeader(
  data,
  headerDf = NULL,
  title = NULL,
  includeRownames = TRUE,
  colHeaderMerge = TRUE
)
}
\arguments{
\item{data}{Data.frame with data.}

\item{headerDf}{(optional) Data.frame with header.
This should contain the same number of columns than \code{data}
(+ if \code{includeRownames} is TRUE) and optionally multiple rows. 
Neighbouring cells with same content
will be represented merged in the output.}

\item{title}{Character vector with title(s) for the table.
Set to NULL (by default) if no title should be included.}

\item{includeRownames}{Logical, if TRUE (by default)
rownames are included in the \code{\link[flextable]{flextable}} object.}

\item{colHeaderMerge}{(flextable output) Logical, if TRUE (FALSE by default) 
the column header is merged.}
}
\value{
list with:
\itemize{
\item{'ft': }{\code{\link[flextable]{flextable}}}
\item{'colsData': }{Named vector with original column names,
with names set to new syntactic names.}
}
}
\description{
Create a flextable, setting the column names to syntactic names
if it is not the case.
}
\author{
Laure Cougnaud
}
