% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inTextSummaryTable-common-args-doc.R
\name{inTextSummaryTable-common-args}
\alias{inTextSummaryTable-common-args}
\title{Arguments used across the functions of the inTextSummaryTable package.}
\arguments{
\item{data}{Data.frame with dataset to consider for the summary table.}

\item{summaryTable}{A \code{\link{summaryTable}} object.}

\item{var}{Character vector with variable(s) of \code{data}, 
to compute statistics on.\cr
If NULL (by default), counts by row/column variable(s) are computed.\cr
To also return counts of the \code{rowVar} in case other \code{var}
are specified, you can include: 'all' in the \code{var}.\cr
Missing values, if present, are filtered 
(also for the report of number of subjects/records).}

\item{varFlag}{Character vector, subset of \code{var} with variable(s) 
of type 'flag' (with 'Y', 'N' or '' for empty/non specified value).
Only the counts for records flagged (with 'Y') are retained.}

\item{varLabInclude}{Logical, if TRUE
the name of the summary statistic variable(s) (\code{var})
are included in the table.
This is automatically set to TRUE if more than one variable(s) 
and is specified, and FALSE if only one variable is specified.}

\item{rowVar}{Character vector with variable(s)
to be included in the rows.
If multiple variables are specified, the variables should 
be sorted in hierarchical order
(e.g. body system class before adverse event term)
and are nested in the table.}

\item{rowVarInSepCol}{Character vector with \code{rowVar}
that should be included in separated columns.
By default (NULL), all row variables are nested in the first column 
of the table.\cr
To include the groups within a \code{var} variable in a separated column, 
set: \code{rowVarInSepCol == 'variableGroup'}.}

\item{rowVarLab}{Named character vector with 
label for the \code{rowVar} variable(s).}

\item{statsVar}{Character vector with columns of \code{summaryTable} with
statistic variables. For the export: if not specified, all columns of \code{data}
besides row, column variables, 'variable', 'variableGroup'
and 'isTotal' are considered.}

\item{rowVarTotalInclude}{Character vector with \code{rowVar}
for which the total should be reported.\cr
If the higher row variable is specified, the total across all rows
is reported. \cr
For the export, these variable(s) are formatted as factor with 
\strong{'Total' as the first level}.}

\item{rowVarTotalInSepRow}{Character vector with \code{rowVarTotalInclude}
(not in \code{rowVarInSepCol}) for which the total should be included in a separated row labelled 'Total'.
Otherwise (by default) the total is included in the header row of each category.}

\item{colVar}{Character vector with variable(s) to be included in columns.
If multiple variables are specified, the variables should 
be sorted in hierarchical order,
and are included in multi-columns layout.\cr
Use: 'variable' to include the variables to summarize: \code{var}
 (if multiple) in different columns.}

\item{colTotalInclude}{Logical, if TRUE (FALSE by default) include the summary 
statistics across columns in a separated column.}

\item{colTotalLab}{String, label for the total column  'Total' by default.\cr}

\item{subjectVar}{String, variable of \code{data} with subject ID,
'USUBJID' by default.}

\item{statsLayout}{String with layout for the statistics names 
(in case more than one statistic is included), among:
\itemize{
\item{row (by default for 'flextable' output): }{All statistics are
 included in different rows in the first column of the table (after the row variable(s))}
\item{'col' (by default for 'DT' output): }{Statistics are included 
in separated columns (last row of the header).\cr
This option is not compatible with categorical variable(s).}
\item{'rowInSepCol': }{Statistics are included in different rows, 
but in a separated column than the \code{rowVar} variable(s)}
}}

\item{statsValueLab}{String with label for the statistic value, 
'StatisticValue' by default.\cr
This is only included in the table if the statistics provided in 
\code{stats} are not named and if no \code{colVar} is specified.}

\item{statsExtra}{(optional) Named list with functions for additional custom
statistics to be computed.\cr
Each function:
\itemize{
\item{has as parameter, either: }{'x': the variable (\code{var}) to compute
the summary statistic on or 'data': the entire dataset}
\item{returns the corresponding summary statistic as a numeric vector}
}
For example, to additionally compute the coefficient of variation, this can be set to:
\code{list(statCVPerc = function(x) sd(x)/mean(x)*100)} (or \code{\link{cv}}).}

\item{type}{String with type of table: 
\itemize{
\item{'summaryTable': }{summary table with statistics for numeric variable}
\item{'countTable': }{count table}
\item{'auto' (by default): }{'summaryTable' if the variable is numeric,
'countTable' otherwise}
}}

\item{statsLabInclude}{Logical, if TRUE include the statistic label
in the table. \cr By default only included if more than
one statistic variables are available in the table.}

\item{title}{Character vector with title(s) for the table.
Set to NULL (by default) if no title should be included.
If multiple are specified, specified for each element of \code{byVar} (in order of the levels).}

\item{pageDim}{Numeric vector of length 2 with page width and height.\cr
Depending on \code{outputType}:
\itemize{
\item{'flextable': }{in inches}
\item{'DT': }{in number of rows in the table.\cr
Currently only the height is used (e.g. \code{c(NA, 4)})
}}}

\item{labelVars}{(optional) Named character vector with label for
the row, column variable(s) or variable(s) to summarize. \cr
Labels specified via dedicated parameter: e.g. 
\code{rowVarLab}, \code{colVarLab}, \code{varLab}
have priority on this parameter.}
}
\value{
No return value, used for the documentation of R functions
}
\description{
Arguments used across the functions of the inTextSummaryTable package.
}
