% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats-getStats.R
\name{getStatsData}
\alias{getStatsData}
\title{Get default set of statistics for variables of interest and specific dataset.}
\usage{
getStatsData(
  data,
  var = NULL,
  type = "default",
  extra = NULL,
  args = NULL,
  ...
)
}
\arguments{
\item{data}{Data.frame with dataset to consider for the summary table.}

\item{var}{(optional, recommended for continuous variable)
Character vector with variable(s) of data, to
compute statistics on.\cr
If NULL (by default), counts of the entire dataset are computed.\cr
It is passed to the \code{x} parameter of \code{\link{getStats}}.}

\item{type}{Character vector with type of statistics to extract, among:
\itemize{
\item{'default': }{default sets of statistics, 
see types: 'summary-default' and 'count-default' in \code{\link{getStats}}}
\item{'all': }{all computed statistics, see types: 'summary' and 'count' in \code{\link{getStats}}}
\item{any formatted statistics as implemented in \code{\link{getStats}}, 
see section 'Formatted statistics' in
\code{\link[=inTextSummaryTable-stats]{in-text table statistics}}.
}
}
To specify statistics for a continuous (numeric) or categorical
variable separately, this vector can be named with: 'cont' or
'cat' respectively (elements not named are used for both continuous 
and categorical variables).}

\item{extra}{List with extra statistics to include, or function to apply on each
\code{var} (e.g. depending on the class of \code{var}) to get such statistic.}

\item{args}{(optional) Named list with extra arguments for 
\code{\link{getStats}} for continuous (name: 'cont') or 
categorical variable (name: 'cat') specifically.}

\item{...}{Extra parameters passed to the \code{\link{getStats}} function
(independent of the variable type).}
}
\value{
List with statistics to compute, named by \code{var}
}
\description{
This set of statistics can be passed directly to the \code{stats} parameter
of the package functions.\cr
By default, statistics are extracted based on the variable(s) type
and formatted with the default rules implemented in the package.
}
\examples{
# default set of statistics (depending if the variable is continuous or categorical)
exampleData <- data.frame(
  USUBJID = 1 : 4, 
  WEIGHT = c(67, 78, 83, 61), 
  SEX = c("F", "M", "M", "F"), 
  stringsAsFactors = FALSE
)
getStatsData(data = exampleData, var = c("WEIGHT", "SEX"))
# all set of statistics (depending if the variable is continuous or categorical)
getStatsData(data = exampleData, var = c("WEIGHT", "SEX"), type = "all")
# custom set of statistics for all variables
getStatsData(data = exampleData, var = c("WEIGHT", "SEX"), type = c("n", "\%"))
# custom set of statistics, depending on the type of the variable
getStatsData(data = exampleData, var = c("WEIGHT", "SEX"), 
  type = c(cont = "median (range)", cont = "mean (se)", cat = "n (\%)"), 
  args = list(cat = list(includeName = FALSE))
)
}
\seealso{
\link{getStats}
}
\author{
Laure Cougnaud
}
