% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_imputed.R
\name{plot_imputed}
\alias{plot_imputed}
\title{Plot imputed time series.}
\usage{
plot_imputed(
  y_imputed,
  column = 1,
  title = "Imputed time series",
  color_imputed = "red",
  type = c("ggplot2", "simple")
)
}
\arguments{
\item{y_imputed}{Imputed time series (can be any object coercible to a numeric vector 
or a numeric matrix). If it has the attribute \code{"index_miss"} (as
returned by any of the imputation functions 
\code{\link{impute_AR1_Gaussian}} and \code{\link{impute_AR1_t}}), then
it will highlight the imputed values in a different color.}

\item{column}{Positive integer indicating the column index to be plotted (only valid if 
the argument \code{y_imputed} is coercible to a matrix with more than one 
column). Default is \code{1}.}

\item{title}{Title of the plot (default is \code{"Imputed time series"}).}

\item{color_imputed}{Color for the imputed values (default is \code{"red"}).}

\item{type}{Type of plot. Valid options: \code{"ggplot2"} and \code{"simple"}. Default is 
\code{"ggplot2"} (the package \code{ggplot2} must be installed).}
}
\description{
Plot single imputed time series (as returned by functions 
             \code{\link{impute_AR1_Gaussian}} and \code{\link{impute_AR1_t}}),
             highlighting the imputed values in a different color.
}
\examples{
library(imputeFin)
data(ts_AR1_t) 
y_missing <- ts_AR1_t$y_missing
y_imputed <- impute_AR1_t(y_missing)
plot_imputed(y_missing, title = "Original time series with missing values")
plot_imputed(y_imputed)

}
\author{
Daniel P. Palomar
}
