% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/src_impala.R
\name{dbGetQuery,src_impala,character-method}
\alias{dbGetQuery,src_impala,character-method}
\title{Send SQL query to Impala and retrieve results}
\usage{
\S4method{dbGetQuery}{src_impala,character}(conn, statement, ...)
}
\arguments{
\item{conn}{object with class class \code{src_impala}}

\item{statement}{a character string containing SQL}

\item{...}{other arguments passed on to methods}
}
\value{
A \code{data.frame} with as many rows as records were fetched and as
  many columns as fields in the result set, even if the result is a single
  value or has one or zero rows
}
\description{
Returns the result of an Impala SQL query as a data frame.
}
\note{
This method is for \code{SELECT} queries only. Use
  \code{\link[=dbExecute,src_impala,character-method]{dbExecute()}} for data
  definition or data manipulation statements.
}
\examples{
\dontrun{
flights_by_carrier_df <- dbGetQuery(
  impala,
  "SELECT carrier, COUNT(*) FROM flights GROUP BY carrier"
)}
}
