% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/im.multiframe.R
\name{im.multiframe}
\alias{im.multiframe}
\title{Set Up a Multi-Frame Plot Layout}
\usage{
im.multiframe(x, y)
}
\arguments{
\item{x}{An integer specifying the number of rows in the plot layout.}

\item{y}{An integer specifying the number of columns in the plot layout.}
}
\value{
No return value. This function modifies the graphical parameters temporarily.
}
\description{
This function sets up a multi-frame plotting layout using `par(mfrow = c(x, y))`,
allowing multiple plots to be displayed in a grid format.
}
\details{
This function changes the `mfrow` graphical parameter using `par()`, enabling multiple plots
to be displayed in a grid layout within the same plotting window. The original plotting
parameters are automatically restored when the function exits.
}
\examples{
# Set up a 2x2 plotting layout
im.multiframe(2, 2)

# Example plots
plot(1:10, rnorm(10))
plot(1:10, runif(10))
plot(1:10, rpois(10, lambda = 5))
plot(1:10, rbeta(10, shape1 = 2, shape2 = 5))

# Layout is automatically restored after im.multiframe() exits

}
\seealso{
[im.ggplot()], [im.import()]
}
