% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measure.R
\name{measure}
\alias{measure}
\title{Prediction error measures}
\usage{
measure(surv.hat, timepoints, tau, method = c("all", "imse",
  "int.error"), L = NULL, R = NULL, surv.true = NULL)
}
\arguments{
\item{surv.hat}{the estimated survival curve matrix with rows representing
the observations and the columns representing the time points at which the
survival curve is estimated.}

\item{timepoints}{a vector of time points at which the survival curve is estimated.}

\item{tau}{the study end time. ([0, \code{tau}] is the window for the analysis.)}

\item{method}{Which measure will be used? Either \code{imse}, \code{int.error} (\code{int.error}
returns both integrated and supremum absolute errors), or \code{all} (both) should be entered.}

\item{L, R}{the left and right interval endpoints. These are required when \code{method == "imse"}
or \code{"all"}.}

\item{surv.true}{the true survival curve matrix with rows representing
the observations and the columns representing the time points at which the
survival curve is evaluated. This is required when \code{method == "int.error"}
or \code{"all"}.}
}
\value{
A vector of prediction errors:
\itemize{
 \item \code{imse.type1} and \code{imse.type2}
when \code{method == "imse"}
 \item \code{int.error} and \code{sup.error}
when \code{method == "int.error"}
 \item \code{imse.type1}, \code{imse.type2}, \code{int.error}, and \code{sup.error}
when \code{method == "all"}
}
}
\description{
This function measures the prediction errors including
the IMSE (integrated mean squared error) of type 1 and 2, the integrated
absolute error, and the supremum absolute error.
When the true survival curve is unknown but the observed interval is available,
IMSE is used. When the true survival curve is known, the integrated and supremum
absolute errors are used.
}
\details{
For details of the error measures, see
Cho H., Jewell N. J., and Kosorok M. R. (2020+). "Interval censored
 recursive forest"
}
\examples{
# rats data example.
# Note that this is a toy example. Use a larger ntree and nfold in practice.
library(survival)  # for Surv()
data(rat2)
L = ifelse(rat2$tumor, 0, rat2$survtime)
R = ifelse(rat2$tumor, rat2$survtime, Inf)
\donttest{
set.seed(1)
rats.icrf <-
  icrf(Surv(L, R, type = "interval2") ~ dose.lvl + weight + male + cage.no,
       data = rat2, ntree = 10, nfold = 3)

measure(rats.icrf$predicted.Sm, timepoints = rats.icrf$time.points,
        tau = rats.icrf$tau, method = "imse", L = L, R = R)
}
\dontshow{
set.seed(2)

rats.icrf <-
  icrf(Surv(L, R, type = "interval2") ~ dose.lvl + weight + male + cage.no,
       data = rat2, ntree = 2, nfold = 2)

measure(rats.icrf$predicted.Sm, timepoints = rats.icrf$time.points,
        tau = rats.icrf$tau, method = "imse", L = L, R = R)
}
}
\references{
\href{https://arxiv.org/abs/1912.09983}{Cho H., Jewell N. J., and Kosorok M. R. (2020+). "Interval censored
 recursive forests"}
}
\author{
Hunyong Cho hunycho@live.unc.edu, based on codes and documents of
\code{randomForest} by Andy Liaw and Matthew Wiener.
}
