% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd-cm-ver.R
\name{with_icd10cm_version}
\alias{with_icd10cm_version}
\title{Evaluate code with a particular version of ICD-10-CM}
\usage{
with_icd10cm_version(ver, code)
}
\arguments{
\item{ver}{Character vector of length one: the version of ICD-10-CM to use,
corresponding to the suffix of the \code{data.frame} name, e.g., for 2019
ICD-10-CM, use \code{"icd10cm2019"} for Dutch 2014 ICD-CM translations, use
\code{"icd10cm2014_nl"}}

\item{code}{Code block to execute, may be in braces, or a single statement
without braces.}
}
\description{
Temporarily sets and restores the option \code{icd.icd10cm_active_year},
analogous to functions in \CRANpkg{withr}.
}
\examples{
icd:::.show_options()
with_icd10cm_version("2014", icd:::.show_options())
}
