% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain_code}
\alias{explain_code}
\alias{explain_icd}
\alias{explain_code.default}
\alias{explain_code.list}
\alias{explain_code.icd9}
\alias{explain_code.icd9cm}
\alias{explain_code.icd10cm}
\alias{explain_code.icd10who}
\alias{explain_code.icd10fr}
\alias{explain_code.icd10be}
\alias{explain_code.icd10}
\title{Explain ICD-9 and ICD-10 codes in English}
\usage{
explain_code(...)

explain_icd(...)

\method{explain_code}{default}(
  x,
  short_code = guess_short(x),
  condense = TRUE,
  brief = FALSE,
  warn = TRUE,
  ...
)

\method{explain_code}{list}(x, ...)

\method{explain_code}{icd9}(...)

\method{explain_code}{icd9cm}(
  x,
  short_code = guess_short(x),
  condense = TRUE,
  brief = FALSE,
  warn = TRUE,
  ...
)

\method{explain_code}{icd10cm}(
  x,
  short_code = guess_short(x),
  condense = TRUE,
  brief = FALSE,
  warn = TRUE,
  ...
)

\method{explain_code}{icd10who}(
  x,
  short_code = guess_short(x),
  condense = TRUE,
  brief = NULL,
  warn = TRUE,
  lang = c("en", "fr"),
  ...
)

\method{explain_code}{icd10fr}(x, ...)

\method{explain_code}{icd10be}(x, lang = c("fr", "nl", "en"), ...)

\method{explain_code}{icd10}(
  x,
  short_code = guess_short(x),
  condense = TRUE,
  brief = FALSE,
  warn = TRUE,
  ...
)
}
\arguments{
\item{...}{arguments passed on to other functions}

\item{x}{vector or other structure of ICD codes to explain in human language}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{condense}{single logical value which indicates whether to condense the
given set of ICD-9 codes by replacing subsets of codes with 'parent' codes
which exactly encompass certain subsets. E.g. If all cholera diagnoses are
provided, only '001 - Cholera' needs to be displayed, not all sub-types.}

\item{brief}{single logical value, default is \code{FALSE}. If \code{TRUE},
the short description from the canonical CMS descriptions will be used,
otherwise the long description is used.}

\item{warn}{single logical value, default is \code{TRUE}, meaning that codes
which do not correspond to diagnoses, or to three-digit codes, will trigger
a warning.}

\item{lang}{For WHO ICD-10 codes, the 2016 English and 2008 French
translations are available. Use \code{en} or \code{fr} respectively.
For ICD-10-CM codes, Dutch is also available, indicated by \code{nl}.}
}
\value{
data frame, or list of data frames, with fields for ICD-9 code, name
  and description. There is no guarantee on the order of the returned
  descriptions. \code{explain_table} is designed to provide results in a
  reliable order (when not condensing codes, at least).
}
\description{
Converts a vector of ICD codes to a vector of descriptions of these codes.
The conversion is based on the edition (ICD-9 or ICD-10), and class (e.g.,
\code{icd10who}) of the input vector. See examples.
}
\details{
\code{explain_icd} is a synonym for \code{\link{explain_code}}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Explain ICD codes from a character vector, guessing
ICD version

\item \code{list}: Explain all ICD-9 codes in a list of vectors

\item \code{icd9}: explain character vector of ICD-9 codes.

\item \code{icd9cm}: explain character vector of ICD-9-CM codes

\item \code{icd10cm}: ICD-10-CM explanation, current a minimal
implementation

\item \code{icd10who}: WHO ICD-10 explanation in French or English

\item \code{icd10fr}: ICD-10-FR explanation, initial implementation,
subject to change

\item \code{icd10be}: ICD-10-BE explanation, initial implementation,
subject to change

\item \code{icd10}: ICD-10 explanation, falls back on ICD-10-CM until
ICD-10 WHO copyright workaround is available
}}

\examples{
# by default, just show parent code and ignore children (428.0 not shown
# because 428 is present):
explain_code(icd9_map_ahrq$CHF[1:3])
# same without condensing the list. In this case, 428.0 is shown:
explain_code(icd9_map_ahrq$CHF[1:3], brief = TRUE)
# The first three in the ICD-10 equivalent are a little different:
explain_code(icd10_map_ahrq$CHF[1:3], brief = TRUE)
\dontrun{
# these may need to download the WHO data first:
explain_code(as.icd10who("B219"), lang = "fr")
explain_code(as.icd10who("B219"))
}
\dontrun{
# Belgian ICD-10 has three languages available
explain_code(as.icd10be("C20"))
# [1] "Malignant neoplasm of rectum"
explain_code(as.icd10be("C20"), lang = "en")
# [1] "Malignant neoplasm of rectum"
explain_code(as.icd10be("C20"), lang = "fr")
# [1] "néoplasme malin du rectum"
explain_code(as.icd10be("C20"), lang = "nl")
# [1] "maligne neoplasma van het rectum"
}
}
\keyword{internal}
