% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{get_valid}
\alias{get_valid}
\alias{get_valid.character}
\alias{get_valid.icd9}
\alias{get_valid.icd10}
\alias{get_valid.icd10cm}
\title{invalid subset of decimal or short_code ICD-9 codes}
\usage{
get_valid(x, short_code = guess_short(x))

\method{get_valid}{character}(x, short_code = guess_short(x))

\method{get_valid}{icd9}(x, short_code = guess_short(x))

\method{get_valid}{icd10}(x, short_code = guess_short(x))

\method{get_valid}{icd10cm}(x, short_code = guess_short(x))
}
\arguments{
\item{x}{input vector of ICD codes}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}
}
\description{
Given vector of short_code or decimal ICD-9 codes, return (in the
  same format) those codes which are valid or invalid. Useful for generating
  error messages with the faulty codes if validation fails.
}
\section{Methods (by class)}{
\itemize{
\item \code{character}: get valid ICD codes from character vector, guessing ICD
version

\item \code{icd9}: Get valid ICD-9 codes

\item \code{icd10}: Get valid ICD-10 codes, currently based on ICD-10-CM
structure, which is a super-set of WHO ICD-10

\item \code{icd10cm}: Get valid ICD-10-CM codes
}}

\concept{ICD-9 validation}
\keyword{internal}
\keyword{manip}
