% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/real.R, R/z-deprecated.R
\name{is_billable}
\alias{is_billable}
\alias{is_billable.icd9}
\alias{is_billable.icd10cm}
\alias{is_billable.icd10}
\alias{is_billable.icd9cm}
\alias{is_billable.default}
\alias{icd_is_billable.default}
\alias{icd_is_billable.icd10}
\alias{icd_is_billable.icd10cm}
\alias{icd_is_billable.icd9}
\alias{icd_is_billable.icd9cm}
\alias{icd_is_billable}
\title{Determine whether codes are billable leaf-nodes}
\usage{
is_billable(x, short_code = guess_short(x), ...)

\method{is_billable}{icd9}(x, short_code = guess_short(x),
  icd9cm_edition = icd9cm_latest_edition(), ...)

\method{is_billable}{icd10cm}(x, short_code = guess_short(x),
  icd10cm_edition = "2016", ...)

\method{is_billable}{icd10}(x, short_code = guess_short(x),
  icd10cm_edition = "2016", ...)

\method{is_billable}{icd9cm}(x, short_code = guess_short(x),
  icd9cm_edition = icd9cm_latest_edition(), nomatch = 0L, ...)

\method{is_billable}{default}(x, short_code = guess_short(x), ...)

icd_is_billable.default(...)

icd_is_billable.icd10(...)

icd_is_billable.icd10cm(...)

icd_is_billable.icd9(...)

icd_is_billable.icd9cm(...)

icd_is_billable(...)
}
\arguments{
\item{x}{input vector to test}

\item{short_code}{single logical value which determines whether the ICD-9
code provided is in short (\code{TRUE}) or decimal (\code{FALSE}) form.
Where reasonable, this is guessed from the input data.}

\item{...}{arguments passed on to other functions}

\item{icd9cm_edition}{single character string, default is "32" which is the
latest release from CMS. Currently anything from "23" to "32" is accepted.
Not numeric because there are possible cases with non-numeric names, e.g.
revisions within one year, although none currently implemented.}

\item{icd10cm_edition}{single character string. ICD-10-CM editions are
currently just the year of release.}

\item{nomatch}{integer value, passed to \code{match} default is 0.}

\item{icd10cm_edition}{single character string. ICD-10-CM editions are
currently just the year of release.}
}
\value{
logical vector of same length as input
}
\description{
Codes provided are compared to the most recent edition of the CMS list of
billable codes, or another edition if specified.
}
\section{Methods (by class)}{
\itemize{
\item \code{icd9}: Which of the given ICD-9 codes are leaf nodes in
ICD-9-CM. Currently assumes ICD-9 codes are ICD-9-CM

\item \code{icd10cm}: Which of the given ICD-10 codes are leaf nodes in
ICD-10-CM. Currently assumes ICD-10 codes are ICD-10-CM

\item \code{icd10}: Which of the given ICD-10 codes are leaf nodes in
ICD-10-CM. Currently assumes ICD-10 codes are ICD-10-CM

\item \code{icd9cm}: Which of the given ICD-9 codes are leaf nodes in
ICD-9-CM

\item \code{default}: Which of the given ICD codes are leaf nodes in
ICD version (9 vs 10) guessed from the codes themselves.
}}

\section{Deprecated function names}{
 Future versions of \pkg{icd} will drop
  the \code{icd_} prefix. For example, \code{charlson} should be used in
  favor of \code{icd_charlson}. To distinguish \pkg{icd} function calls,
  consider using the namespace prefix \code{icd::} instead, e.g.,
  \code{icd::charlson}. Functions which specifically operate on either ICD-9
  or ICD-10 codes or their subtypes will retain the prefix. E.g.
  \code{\link{icd9_comorbid_ahrq}}. \pkg{icd} specific classes also retain
  the prefix, e.g., \code{\link{icd_wide_data}}.
}

\keyword{internal}
