# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Convert \code{mjr} and \code{mnr} vectors to single code
#'
#' In debug mode, will check that \code{mjr} and \code{mnr} are same length.
#' @template mjr
#' @template mnr
#' @template isShort
#' @examples
#' \dontrun{
#' n <- 5e6
#' mjrs <- as.character(sample(1:999, n, replace = TRUE))
#' mnrs <- as.character(sample(0:99, n, replace = TRUE))
#' microbenchmark::microbenchmark(
#'   icd9MajMinToCode(mjrs, mnrs, TRUE),
#'   icd9MajMinToCodeStd(mjrs, mnrs, TRUE),
#'   icd9MajMinToCodePrePadded(mjrs, mnrs, TRUE),
#'   times = 10
#' )
#' }
#' # std method about the same with O3 (4% faster, but no NA handling), but 50% quicker with O0
#' # std method without doing padding is 5 times quicker than previous...
#' @keywords internal manip
icd9MajMinToCode <- function(mjr, mnr, isShort) {
    .Call('icd_icd9MajMinToCode', PACKAGE = 'icd', mjr, mnr, isShort)
}

#' @describeIn icd9MajMinToCode Same as \code{icd9MajMinToCode} but assume
#' codes are already trimmed and correctly padded with zeros, e.g. E001, V09,
#' 001. This version does handle NA values correctly. ' @keywords internal
icd9MajMinToCodePrePadded <- function(mjr, mnr, isShort) {
    .Call('icd_icd9MajMinToCodePrePadded', PACKAGE = 'icd', mjr, mnr, isShort)
}

icd9MajMinToCodeStd <- function(mjr, mnr, isShort) {
    .Call('icd_icd9MajMinToCodeStd', PACKAGE = 'icd', mjr, mnr, isShort)
}

icd9MajMinToShort <- function(mjr, mnr) {
    .Call('icd_icd9MajMinToShort', PACKAGE = 'icd', mjr, mnr)
}

icd9MajMinToDecimal <- function(mjr, mnr) {
    .Call('icd_icd9MajMinToDecimal', PACKAGE = 'icd', mjr, mnr)
}

#' append minor to major using std
#'
#' benefits from having reserve string size of 5
#' @keywords internal
icd9AppendMinors <- function(m, mnr, isShort) {
    invisible(.Call('icd_icd9AppendMinors', PACKAGE = 'icd', m, mnr, isShort))
}

#' initialize a std::vector of strings with repeated value of the minor
#' @keywords internal
icd9MajMinToShortStd <- function(mjr, mnr) {
    .Call('icd_icd9MajMinToShortStd', PACKAGE = 'icd', mjr, mnr)
}

icd9MajMinToShortSingleStd <- function(mjr, mnr) {
    .Call('icd_icd9MajMinToShortSingleStd', PACKAGE = 'icd', mjr, mnr)
}

#' Set ICD short-form diagnosis code attribute
#'
#' Doing this in an R function doesn't work for 'void' equivalent, and does a
#' copy if the updated object is returned.
#' @examples
#' j <- "100"
#' attr(j, "icd_short_diag") <- TRUE
#' j
#' attr(j, "icd_short_diag") <- FALSE
#' j
#' icd:::.attr_decimal_diag(j)
#' as.icd_decimal_diag(j)
#' \dontrun{
#' library(pryr)
#' j <- 1
#' c(address(j), refs(j))
#' attr(j, "icd_short_diag") <- TRUE
#' c(address(j), refs(j))
#' attr(j, "icd_short_diag") <- FALSE
#' c(address(j), refs(j))
#' icd:::.attr_decimal_diag(j)
#' c(address(j), refs(j))
#' j <- as.icd_decimal_diag(j, TRUE)
#' c(address(j), refs(j))
#' # Rcpp cleverer than R, and doesn't return a copy of the data
#' }
#' @keywords internal attribute
.attr_decimal_diag <- function(x, value = TRUE) {
    invisible(.Call('icd_setDecimalDiag', PACKAGE = 'icd', x, value))
}

#' @rdname as.icd_short_diag
#' @keywords internal attribute
.attr_short_diag <- function(x, value = TRUE) {
    invisible(.Call('icd_setShortDiag', PACKAGE = 'icd', x, value))
}

icd10cm_children_defined_cpp <- function(x) {
    .Call('icd_icd10cmChildrenDefined', PACKAGE = 'icd', x)
}

#' @rdname icd_comorbid
#' @description \code{\link{Rcpp}} approach to comorbidity assignment with
#'   OpenMP and vector of integers strategy. It is very fast, and most time is
#'   now spent setting up the data to be passed in.
#' @param aggregate single logical value, if \code{TRUE}, then take (possible
#'   much) more time to aggregate out-of-sequence visit IDs in the input
#'   data.frame. If this is \code{FALSE}, then each contiguous group of visit
#'   IDs will result in a row of comorbidities in the output data. If you know
#'   whether your visit IDs are disordered, then use \code{TRUE}.
#' @keywords internal
icd9ComorbidShortCpp <- function(icd9df, icd9Mapping, visitId, icd9Field, threads = 8L, chunk_size = 256L, omp_chunk_size = 1L, aggregate = TRUE) {
    .Call('icd_icd9ComorbidShortCpp', PACKAGE = 'icd', icd9df, icd9Mapping, visitId, icd9Field, threads, chunk_size, omp_chunk_size, aggregate)
}

#' core search for ICD code in a map
#' @keywords internal
lookupComorbidByChunkFor <- function(vcdb, map, chunkSize, ompChunkSize, out) {
    invisible(.Call('icd_lookupComorbidByChunkFor', PACKAGE = 'icd', vcdb, map, chunkSize, ompChunkSize, out))
}

#' Internal function to find ICD-10 parents
#'
#' Written in C++ for speed. There are no default arguments and there is no
#' value guessing.
#' @param x Character vector (not factor)
#' @template mapping
#' @template visit_name
#' @template icd_name
#' @seealso \url{https://github.com/s-u/fastmatch/blob/master/src/fastmatch.c}
#' @keywords internal
icd10_comorbid_parent_search_cpp <- function(x, map, visit_name, icd_name) {
    .Call('icd_icd10_comorbid_parent_search_cpp', PACKAGE = 'icd', x, map, visit_name, icd_name)
}

icd9MajMinToCodeOld <- function(mjr, mnr, isShort) {
    .Call('icd_icd9MajMinToCodeOld', PACKAGE = 'icd', mjr, mnr, isShort)
}

#' @rdname convert
#' @keywords internal manip
icd9PartsToShort <- function(parts) {
    .Call('icd_icd9PartsToShort', PACKAGE = 'icd', parts)
}

#' @rdname convert
#' @keywords internal manip
icd9PartsToDecimal <- function(parts) {
    .Call('icd_icd9PartsToDecimal', PACKAGE = 'icd', parts)
}

icd9MajMinToParts <- function(mjr, mnr) {
    .Call('icd_icd9MajMinToParts', PACKAGE = 'icd', mjr, mnr)
}

#' @rdname convert
#' @keywords internal manip
icd9ShortToPartsCpp <- function(icd9Short, mnrEmpty) {
    .Call('icd_icd9ShortToPartsCpp', PACKAGE = 'icd', icd9Short, mnrEmpty)
}

#' @describeIn icd_decimal_to_parts Convert short ICD-10 code to parts
#' @export
#' @keywords internal manip
icd_short_to_parts.icd10 <- function(x, mnr_empty = "") {
    .Call('icd_icd10ShortToPartsCpp', PACKAGE = 'icd', x, mnr_empty)
}

#' @rdname convert
#' @keywords internal manip
icd9DecimalToPartsCpp <- function(icd9Decimal, mnr_empty) {
    .Call('icd_icd9DecimalToPartsCpp', PACKAGE = 'icd', icd9Decimal, mnr_empty)
}

#' @describeIn icd_decimal_to_parts Convert decimal ICD-10 code to parts. This
#'   shares almost 100% code with the ICD-9 version: someday combine the common
#'   code.
#' @export
#' @keywords internal manip
icd_decimal_to_parts.icd10 <- function(x, mnr_empty = "") {
    .Call('icd_icd10DecimalToPartsCpp', PACKAGE = 'icd', x, mnr_empty)
}

icd9_short_to_decimal_cpp <- function(x) {
    .Call('icd_icd9ShortToDecimal', PACKAGE = 'icd', x)
}

icd9_decimal_to_short_cpp <- function(x) {
    .Call('icd_icd9DecimalToShort', PACKAGE = 'icd', x)
}

#' @describeIn icd_get_major Get major part of ICD-9 code, i.e. first three
#'   digits of numeric or V code, or first four digits of E code. This is the
#'   part before the decimal, when a decimal point is used.
#' @keywords internal manip
icd_get_major.icd9 <- function(x, short_code) {
    .Call('icd_icd9GetMajor', PACKAGE = 'icd', x, short_code)
}

#' @name fastIntToString
#' @title Fast convert integer vector to character vector
#' @description Fast conversion from integer vector to character vector using C++
#' @param x vector of integers
#' @param bufferSize int if any input strings are longer than this number
#'   (default 16) there will be memory errors. No checks done for speed.
#' @examples
#' \dontrun{
#' pts <- generate_random_pts(1e7)
#' # conclusion: buffer size matters little (so default to be more generous),
#' # and 'Rcpp' version fastest.
#' microbenchmark::microbenchmark(fastIntToStringStd(pts$visit_id, buffer = 8),
#'                                fastIntToStringStd(pts$visit_id, buffer = 16),
#'                                fastIntToStringStd(pts$visit_id, buffer = 64),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 8),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 16),
#'                                fastIntToStringRcpp(pts$visit_id, buffer = 64),
#'                                as.character(pts$visit_id),
#'                                as_char_no_warn(pts$visit_id), times = 5)
#' }
#' @keywords internal
fastIntToStringStd <- function(x) {
    .Call('icd_fastIntToStringStd', PACKAGE = 'icd', x)
}

#' @describeIn fastIntToString Same using \code{Rcpp}
fastIntToStringRcpp <- function(x) {
    .Call('icd_fastIntToStringRcpp', PACKAGE = 'icd', x)
}

#' Guess whether codes are \code{short_code} or \code{decimal_code}
#'
#' The goal is to guess whether codes are \code{short_code} or
#' \code{decimal_code} form. Currently condense works, but not with the
#' \code{icd} look-up table currently in use. Of note, validation is a bit
#' different here, since we don't know the type until after we guess. We could
#' look for where both short_code and long are invalid, and otherwise assume
#' valid, even if the bulk are short_code. However, it may be more useful to
#' check validity after the guess.
#' @details Very quick heuristic, ploughs through ten million codes in less
#'   than one second and will stop more quickly if it finds a '.'.
#' @return single logical value, \code{TRUE} if input data are predominantly
#'   \code{short_code} type. If there is some uncertainty, then return
#'   \code{NA}.
#' @keywords internal
icd_guess_short <- function(x_, short_code = NULL, n = 1000L, icd_name = NULL) {
    .Call('icd_guessShortCompleteCpp', PACKAGE = 'icd', x_, short_code, n, icd_name)
}

guessShortPlusFactorCpp <- function(x_, n) {
    .Call('icd_guessShortPlusFactorCpp', PACKAGE = 'icd', x_, n)
}

#' Do elements of vector begin with V, E (or any other character)?
#'
#' Current returns a vector of \code{bool} which is not thread safe, or
#' particularly fast, although it is memory efficient in the standard
#' implementation. As of \code{icd9} (now known as \code{icd}) version 1.2,
#' this is not called by threaded code, but this could change, so beware! ASCII
#' spaces are trimmed from the start of the string before testing, but no other
#' white space
#' @param sv vector of strings
#' @param x \code{const char*} of choices of first character to match
#' @param invert single logical, if TRUE, negates the condition
#' @keywords internal
icd9_is_n_cpp <- function(sv) {
    .Call('icd_icd9_is_n_cpp', PACKAGE = 'icd', sv)
}

#' @rdname icd9_is_n_cpp
#' @keywords internal
icd9_is_v_cpp <- function(sv) {
    .Call('icd_icd9_is_v_cpp', PACKAGE = 'icd', sv)
}

#' @rdname icd9_is_n_cpp
#' @keywords internal
icd9_is_e_cpp <- function(sv) {
    .Call('icd_icd9_is_e_cpp', PACKAGE = 'icd', sv)
}

icd_long_to_wide_cpp <- function(icd9df, visitId, icd9Field, aggregate = TRUE) {
    .Call('icd_icd9LongToWideCpp', PACKAGE = 'icd', icd9df, visitId, icd9Field, aggregate)
}

icd9AddLeadingZeroesShortSingle <- function(x) {
    .Call('icd_icd9AddLeadingZeroesShortSingle', PACKAGE = 'icd', x)
}

icd9_add_leading_zeroes_alt_cpp <- function(x, short_code) {
    .Call('icd_icd9AddLeadingZeroesDirect', PACKAGE = 'icd', x, short_code)
}

icd9AddLeadingZeroesMajorSingle <- function(mjr) {
    .Call('icd_icd9AddLeadingZeroesMajorSingle', PACKAGE = 'icd', mjr)
}

icd9AddLeadingZeroesMajorSingleStd <- function(m) {
    .Call('icd_icd9AddLeadingZeroesMajorSingleStd', PACKAGE = 'icd', m)
}

icd9_add_leading_zeroes_major <- function(mjr) {
    .Call('icd_icd9AddLeadingZeroesMajor', PACKAGE = 'icd', mjr)
}

#' @title Add leading zeroes to incomplete ICD-9 codes
#' @description Non-decimal ICD-9 codes with length<5 are often ambiguous. E.g.
#'   100 could be 1.00 10.0 or 100 if coded incorrectly. We must assume 100 is
#'   really 100
#' @param x Character vector of ICD-9 codes
#' @template short_code
#' @return character vector of ICD-9 codes with leading zeroes
#' @examples
#' \dontrun{
#' stopifnot(identical(
#'   icd9_add_leading_zeroes_alt_cpp(c("1", "E2", "V1", "E"), short_code = TRUE),
#'   icd9_add_leading_zeroes_cpp(c("1", "E2", "V1", "E"), short_code = TRUE)
#'   ))
#'
#'   bad_codes <- sample(c("E2", "V01", "1234", "12", "1", "E99", "E987", "V"),
#'                       size = 1e6, replace = TRUE)
#'   microbenchmark::microbenchmark(
#'     icd9_add_leading_zeroes_alt_cpp(bad_codes, short_code = TRUE),
#'     icd9_add_leading_zeroes_cpp(bad_codes, short_code = TRUE)
#'   )
#' }
#' @keywords internal manip
icd9_add_leading_zeroes_cpp <- function(x, short_code) {
    .Call('icd_icd9AddLeadingZeroes', PACKAGE = 'icd', x, short_code)
}

#' Find child codes from vector of ICD-9 codes.
#'
#' Pure C++11 implementation using \code{unordered set} to find children of
#' given codes
#' @examples
#' \dontrun{
#' microbenchmark::microbenchmark(
#'   icd9ChildrenShort(c("001", 100:500), onlyReal = TRUE),
#'   icd9ChildrenShort11(c("001", 100:500), onlyReal = TRUE),
#'   times = 5)
#'   # C++11 about 15% faster for this data
#' }
#' @keywords internal
icd9ChildrenShort11 <- function(icd9Short, onlyReal) {
    .Call('icd_icd9ChildrenShort11', PACKAGE = 'icd', icd9Short, onlyReal)
}

#' C++ implementation of finding children of short codes
#' @examples
#' \dontrun{
#' library(microbenchmark)
#' microbenchmark(icd9ChildrenShort("001", T), icd9ChildrenShortStd("001", T), times = 100)
#' microbenchmark(icd9ChildrenShort(c("001", 100:400), T),
#'                icd9ChildrenShortUnordered(c("001", 100:400), T),
#'                icd9ChildrenShortStd(c("001", 100:400), T),
#'                times = 10)
#' }
#' # un-ordered set much faster, but may still need to sort result
#' @keywords internal
icd9ChildrenShortStd <- function(icd9Short, onlyReal) {
    .Call('icd_icd9ChildrenShortStd', PACKAGE = 'icd', icd9Short, onlyReal)
}

icd9ExpandMinorStd <- function(mnr, isE) {
    .Call('icd_icd9ExpandMinorStd', PACKAGE = 'icd', mnr, isE)
}

icd9_expand_minor_wrap <- function(mnr, isE) {
    .Call('icd_icd9ExpandMinor', PACKAGE = 'icd', mnr, isE)
}

icd9ChildrenShort <- function(icd9Short, onlyReal) {
    .Call('icd_icd9ChildrenShort', PACKAGE = 'icd', icd9Short, onlyReal)
}

icd9ChildrenShortUnordered <- function(icd9Short, onlyReal) {
    .Call('icd_icd9ChildrenShortUnordered', PACKAGE = 'icd', icd9Short, onlyReal)
}

icd9ChildrenShortNoNaUnordered <- function(icd9Short, onlyReal) {
    .Call('icd_icd9ChildrenShortNoNaUnordered', PACKAGE = 'icd', icd9Short, onlyReal)
}

icd9ChildrenDecimalCpp <- function(icd9Decimal, onlyReal) {
    .Call('icd_icd9ChildrenDecimalCpp', PACKAGE = 'icd', icd9Decimal, onlyReal)
}

icd9ChildrenCpp <- function(icd9, isShort, onlyReal = TRUE) {
    .Call('icd_icd9ChildrenCpp', PACKAGE = 'icd', icd9, isShort, onlyReal)
}

#' @title match ICD9 codes
#' @description Finds children of \code{icd9Reference} and looks for \code{icd9} in the
#'   resulting vector.
#' @templateVar icd9AnyName "icd9,icd9Reference"
#' @template icd9-any
#' @template short_code
#' @param isShortReference logical, see argument \code{short_code}
#' @return logical vector
#' @keywords internal
icd_in_reference_code <- function(icd, icd_reference, short_code, short_reference = TRUE) {
    .Call('icd_icd_in_reference_code', PACKAGE = 'icd', icd, icd_reference, short_code, short_reference)
}

trimLeftCpp <- function(s) {
    .Call('icd_trimLeftCpp', PACKAGE = 'icd', s)
}

strimCpp <- function(s) {
    .Call('icd_strimCpp', PACKAGE = 'icd', s)
}

trimCpp <- function(sv) {
    .Call('icd_trimCpp', PACKAGE = 'icd', sv)
}

getOmpCores <- function() {
    .Call('icd_getOmpCores', PACKAGE = 'icd')
}

getOmpMaxThreads <- function() {
    .Call('icd_getOmpMaxThreads', PACKAGE = 'icd')
}

getOmpThreads <- function() {
    .Call('icd_getOmpThreads', PACKAGE = 'icd')
}

randomMajorCpp <- function(n) {
    .Call('icd_randomMajorCpp', PACKAGE = 'icd', n)
}

#' @rdname icd9RandomShort
#' @keywords internal
icd9RandomShortN <- function(n = 5L) {
    .Call('icd_icd9RandomShortN', PACKAGE = 'icd', n)
}

#' @rdname icd9RandomShort
#' @keywords internal
icd9RandomShortV <- function(n = 5L) {
    .Call('icd_icd9RandomShortV', PACKAGE = 'icd', n)
}

#' @rdname icd9RandomShort
#' @keywords internal
icd9RandomShortE <- function(n = 5L) {
    .Call('icd_icd9RandomShortE', PACKAGE = 'icd', n)
}

#' Generate random short-form ICD-9 codes
#'
#' Quick pseudo-random by picking numeric, 'V' or 'E' based on modulo three of
#' the number
#' @keywords internal
icd9RandomShort <- function(n = 5L) {
    .Call('icd_icd9RandomShort', PACKAGE = 'icd', n)
}

valgrindCallgrindStart <- function(zerostats = FALSE) {
    .Call('icd_valgrindCallgrindStart', PACKAGE = 'icd', zerostats)
}

valgrindCallgrindStop <- function() {
    .Call('icd_valgrindCallgrindStop', PACKAGE = 'icd')
}

icd9_sort_cpp <- function(x) {
    .Call('icd_icd9SortCpp', PACKAGE = 'icd', x)
}

icd9_order_cpp <- function(x) {
    .Call('icd_icd9OrderCpp', PACKAGE = 'icd', x)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('icd_RcppExport_registerCCallable', PACKAGE = 'icd')
})
