% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sas.R
\name{sas_format_extract}
\alias{sas_format_extract}
\alias{sas_format_extract_rcomfmt}
\title{Extract assignments from a SAS FORMAT definition}
\usage{
sas_format_extract(sas_lines)

sas_format_extract_rcomfmt(sas_lines)
}
\arguments{
\item{sas_lines}{is a character vector, with one item per line, e.g. from
\code{readLines}}
}
\value{
list (of lists)
}
\description{
This is modelled entirely on a single chunk of SAS code, but hopefully can be
generalised. It relies heavily on lists and regular expression, but, as you
will see from the code, R is not a great language with which to write a SAS
parser.
}
\section{Functions}{
\itemize{
\item \code{sas_format_extract_rcomfmt}: Get just the \code{$RCOMFMT} assignment, which
  contains all the ICD (not DRG) data. The problem is \code{RENLFAIL} appears
  twice:

  \code{"N183", "N184", "N185", "N186", "N189", "N19", "Z4901", "Z4902",
  "Z9115", "Z940", "Z992"="RENLFAIL"         /*Dependence on renal dialysis*/

  "Z4931", "Z4932"="RENLFAIL"       /*Encounter for adequacy testing for
  peritoneal dialysis*/ }

  so \code{RENLFAIL} needs special treatment
}}
\examples{
  \dontrun{
  sas_format_extract(readLines('data-raw/comformat2012-2013.txt'))
  }
}
\references{
\url{http://support.sas.com/documentation/cdl/en/proc/61895/HTML/default/viewer.htm#a002473474.htm}
}
\keyword{internal}
\keyword{list}
\keyword{programming}

