% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datadocs.R
\docType{data}
\name{icd9_map_hcc}
\alias{icd10_map_cc}
\alias{icd9_map_cc}
\alias{icd9_map_hcc}
\alias{icd_map_cc_hcc}
\title{Medicare Hierarchical Condition Categories}
\format{\code{dataframe} with 3 columns (\code{icd_code}, \code{cc}, and \code{year})}
\description{
Medicare HCC model was developed to use current year diagnoses and demographics
predict current year healthcare expenditure. This classification has been used
for additional risk adjustment models. ICD codes are first assigned to numeric
Condition Categories (CCs). A hierarchy rule is then applied so that each patient
is coded for only the most severe of the Condition Categories in a group. For example,
if a patient has metastatic lung cancer, they will only be assigned the CC
for "Metastatic Cancer and Acute Leukemia", and will not be assigned the
CC for "Lung and other Severe Cancers". Once the hierarchy rules are applied, the codes
are referred to as HCCs. This mapping can change over time. It remained the same from
2007-10
}
\references{
Pope, Gregory C., et al.
  "Diagnostic cost group hierarchical condition category models for Medicare risk adjustment."
  Health Economics Research, Inc. Waltham, MA (2000).
  \url{https://www.cms.gov/Research-Statistics-Data-and-Systems/Statistics-Trends-and-Reports/Reports/Downloads/Pope_2000_2.pdf}

  Risk Adjustment, Centers for Medicare and Medicaid Services
  \url{https://www.cms.gov/Medicare/Health-Plans/MedicareAdvtgSpecRateStats/Risk-Adjustors.html}
}
\keyword{datasets}

