% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{icd9Explain}
\alias{icd9Explain}
\alias{icd9Explain.character}
\alias{icd9Explain.list}
\alias{icd9Explain.numeric}
\alias{icd9ExplainDecimal}
\alias{icd9ExplainShort}
\title{Deprecated: explain ICD codes in words}
\usage{
icd9Explain(icd9, isShort = icd_guess_short(icd9), doCondense = TRUE,
  brief = FALSE, warn = TRUE)

\method{icd9Explain}{character}(icd9, isShort = icd9GuessIsShort(icd9),
  doCondense = TRUE, brief = FALSE, warn = TRUE)

\method{icd9Explain}{numeric}(icd9, isShort = icd_guess_short(icd9),
  doCondense = TRUE, brief = FALSE, warn = FALSE)

\method{icd9Explain}{list}(icd9, isShort = icd_guess_short(icd9),
  doCondense = TRUE, brief = FALSE, warn = TRUE)

icd9ExplainShort(icd9Short, doCondense = TRUE, brief = FALSE, warn = TRUE)

icd9ExplainDecimal(icd9Decimal, doCondense = TRUE, brief = FALSE,
  warn = TRUE)
}
\arguments{
\item{icd9}{is a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{isShort}{Deprecated. Single logical value which determines whether the
ICD-9 code provided is in short (\code{TRUE}) or decimal (\code{FALSE})
form. Where reasonable, this is guessed from the input data.}

\item{doCondense}{single logical value which indicates whether to condense
the given set of ICD-9 codes by replacing subsets of codes with 'parent'
codes which exactly encompass certain subsets. E.g. If all cholera
diagnoses are provided, only '001 - Cholera' needs to be displayed, not all
sub-types.}

\item{brief}{logical}

\item{warn}{single logical value, if \code{TRUE}, give warnings when
there is discrepancy between \code{onlyReal} being \code{TRUE} yet data
containing undefined codes.}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than five characters is
given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010"}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five characters is given in a
code, then the digits are greedily assigned to hundreds, then tens, then
units, before the decimal parts. E.g. "10" becomes "010", not "0010"}
}
\description{
Use \code{icd_explain} instead.
}
\keyword{internal}

