% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{rv.cor.matrix}
\alias{rv.cor.matrix}
\title{A correlation matrix of RV coefficients}
\usage{
rv.cor.matrix(config_matrices)
}
\arguments{
\item{config_matrices}{The result from compute.config.matrices().}
}
\value{
An n x n matrix of pairwise RV coefficients, where n is the number of datasets.
}
\description{
Given a list of n configuration matrices (corresponding to n datasets), this function computes an n x n matrix of pairwise RV coefficients.
}
\examples{
set.seed(2)
n = 100
p = 100
x1 = matrix(rnorm(n*p), n, p)
x2 = x1 + matrix(rnorm(n*p), n, p)
x3 = x2 + matrix(rnorm(n*p), n, p)
data = list(x1=x1, x2=x2, x3=x3)
config_matrices = compute.config.matrices(data)
cors = rv.cor.matrix(config_matrices)
}
