% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_dict.R
\name{read_dictionary}
\alias{read_dictionary}
\alias{print.dictionary}
\alias{[.dictionary}
\alias{apply_dictionary}
\alias{has_dictionary}
\alias{get_dictionary}
\title{Data dictionaries}
\usage{
read_dictionary(
  file,
  name = "name",
  type = "type",
  title = "title",
  description = "description",
  units = "units",
  codes = "codes",
  values = "values",
  level_separator = "|",
  ...
)

\method{print}{dictionary}(x, kable = FALSE, include_other = TRUE, ...)

\method{[}{dictionary}(x, i, ...)

apply_dictionary(data, dict)

has_dictionary(data)

get_dictionary(data)
}
\arguments{
\item{file}{path to a file}

\item{name}{name of the column containing the variable name}

\item{type}{column containing the variable type}

\item{title}{the column containing a short, human-readable title for the variable - if blank, the variable name will be used instead}

\item{description}{name of the column containing the variable description}

\item{units}{column containing units (for numeric variables only)}

\item{codes}{column containing factor codes}

\item{values}{column containing factor values - these should be in the same order}

\item{level_separator}{the separator used to separate levels in \code{codes} and \code{values} columns, default "|". Can optionally be a vector of length 2, in which case the first is used for \code{codes} and the second for \code{values}.}

\item{...}{additional arguments, passed to \code{smart_read}}

\item{x}{a \code{dictionary} object}

\item{kable}{if \code{TRUE} outputs a kable instead}

\item{include_other}{if \code{TRUE} additional variables will be included in the output}

\item{i}{Subset index}

\item{data}{a dataset (dataframe, tibble)}

\item{dict}{a dictionary (created using \code{read_dictionary()})}
}
\description{
Read a data dictionary from file, attach to a dataset (plus utility functions).
These can then be used by other methods (such as plots) to automatically create
axes, etc.
}
\section{Units and codes}{


For numeric variables, the dictionary can specify the units used in the measurements.

For categorical variables, often these are coded rather than printed in full in the dataset. Data dictionaries may specify a column containing the codes (with a separator) and
}

