% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{add_suffix}
\alias{add_suffix}
\title{Add suffix to string}
\usage{
add_suffix(name, suffix)
}
\arguments{
\item{name}{a character vector containing (original) names}

\item{suffix}{the suffix to add, a length-one character vector}
}
\value{
character vector of names with suffix appended
}
\description{
When creating new variables or modifying the data set, we often
add a suffix added to distinguish the new name from the original one.
However, if the same action is performed twice (for example, filtering a data set),
the suffix is duplicated (data.filtered.filtered). This function averts this
by adding the suffix if it doesn't exist, and otherwise appending
a counter (data.filtered2).
}
\examples{
add_suffix("data", "filtered")
add_suffix(c("data.filtered", "data.filtered.reshaped"), "filtered")
}
