% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IARphikalman}
\alias{IARphikalman}
\title{Minus Log Likelihood of the IAR Model estimated via Kalman Recursions}
\usage{
IARphikalman(x, y, yerr, st, zeroMean = "TRUE", standarized = "TRUE")
}
\arguments{
\item{x}{A given phi coefficient of the IAR model.}

\item{y}{Array with the time series observations.}

\item{yerr}{Array with the measurements error standard deviations.}

\item{st}{Array with the irregular observational times.}

\item{zeroMean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}

\item{standarized}{logical; if true, the array y is standarized; if false, y contains the raw time series.}
}
\value{
Value of the negative log likelihood evaluated in phi.
}
\description{
This function return the negative log likelihood of the IAR process given a specific value of phi.
}
\examples{
set.seed(6714)
st<-gentime(n=100)
y<-IARsample(phi=0.99,st=st,n=100)
y<-y$series
yerr=rep(0,100)
IARphikalman(x=0.8,y=y,yerr=yerr,st=st)
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARsample}}
}
