% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/affineCoords.R
\name{affineCoords}
\alias{affineCoords}
\title{Affine Transformation (rotation and shift) on Spatial Coordinates}
\usage{
affineCoords(s, angle = 0, xy_shift = c(0, 0))
}
\arguments{
\item{s}{A spatial object where \code{\link[raster:xyFromCell]{raster::coordinates()}} can be extracted from.
Example classes: \code{Extent}, \code{RasterLayer}, \code{RasterBrick},
\code{RasterStack} (from package \link{raster}), \code{SpatialPolygon}
(from package sp).}

\item{angle}{A numeric value of the angle (in degrees, 0-360) to rotate
\code{s}. A negative value will change the direction of rotation to
clockwise.}

\item{xy_shift}{A numeric vector of length two with the x and y shift (the
translation parameters).}
}
\value{
A two-column matrix with the transformed coordinates (xy).
}
\description{
Affine transformations are of type \eqn{f(x) = Ax + b}, where \eqn{x} is
the spatial coordinates (2D in this case), \eqn{A} is a rotation matrix
(it can also include scale/shear parameters, but only rotation is
considered here), and \eqn{b} is the translation (xy shift) parameters.
}
\examples{
p <- system.file('exdata', 'soybean.tif', package = 'hyperbrick')
im <- brick(p)
print(im)

# view band-3
plot(im[[3]], col = gray.colors(20), asp = 0)

# draw a spatial polygon on image
pol <- Polygon(extent(c(40, 85, 50, 150)))
lines(pol)

# rotate and shift the spatial polygon
new_pol <- affineCoords(pol, angle = -3, xy_shift = c(-11, 0))
plot(im[[3]], col = gray.colors(20), asp = 0)
lines(new_pol)

# do some analysis within it, like:
new_pols <- SpatialPolygons(list(Polygons(list(Polygon(new_pol)), "id0")))
plot(mask(im[[3]], new_pols))
mean(extract(im[[3]], new_pols)[[1]])

}
\seealso{
\code{\link[=affineBrick]{affineBrick()}}
}
