% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperbolicDEA.R
\name{hyperbolicDEA}
\alias{hyperbolicDEA}
\title{Hyperbolic estimation of DEA efficiency scores}
\usage{
hyperbolicDEA(
  X,
  Y,
  RTS = "vrs",
  WR = NULL,
  SLACK = FALSE,
  ACCURACY = 1e-10,
  XREF = NULL,
  YREF = NULL,
  SUPEREFF = FALSE,
  NONDISC_IN = NULL,
  NONDISC_OUT = NULL,
  PARALLEL = 1,
  ALPHA = 0.5
)
}
\arguments{
\item{X}{Vector, matrix or dataframe with DMUs as rows and inputs as columns}

\item{Y}{Vecotr, matrix or dataframe with DMUs as rows and outputs as columns}

\item{RTS}{Character string indicating the returns-to-scale, e.g. "crs", "vrs", "ndrs", "nirs", "fdh"}

\item{WR}{Matrix with one row per homogeneous linear weight restriction in standard form. The columns are 
ncol(WR) = ncol(Y) + ncol(X). Hence the first ncol(Y) columns are the restrictions on outputs and the last ncol(X) columns are the 
restrictions on inputs.}

\item{SLACK}{Boolean variable indicating whether an additional estimation of slacks shall be performed when set to 'TRUE'.
Be aware that SLACK estimation can change the lambda values.}

\item{ACCURACY}{Accuracy value for non-linear programm solver.}

\item{XREF}{Vector, matrix or dataframe with firms defining the technology as rows and inputs as columns}

\item{YREF}{Vector, matrix or dataframe with firms defining the technology as rows and outputs as columns}

\item{SUPEREFF}{Boolean variable indicating whether super-efficiencies shall be estimated}

\item{NONDISC_IN}{Vector containing column indices of the input matrix that are non-discretionary variables e.g. c(1,3) so the first and the third input are non-discretionary}

\item{NONDISC_OUT}{Vector containing column indices of the output matrix that are non-discretionary variables e.g. c(1,3) so the first and the third output are non-discretionary}

\item{PARALLEL}{Integer of amount of cores that should be used for parallel computing (Check availability of computer)}

\item{ALPHA}{ALPHA can be chosen between [0,1]. It indicates the relative weights given to the distance function to
both outputs and inputs when approaching the frontier. More weight on the input orientation is set by alpha < 0.5. Here,
the input efficiency score is estimated in the package. To receive the corresponding output efficiency score, estimate: e^((1-alpha)/alpha).
Vice versa for an output weighted model alpha > 0.5. The output efficiency is given and the input efficiency can
be recovered with: e^(alpha/(1-alpha))}
}
\value{
A list object containing the following information:
\item{eff}{Are the estimated efficiency scores for the DMUs under observation stored 
in a vector with the length nrow(X).}
\item{lambdas}{Estimated values for the composition of the respective Benchmarks.
The lambdas are stored in a matrix with the dimensions nrow(X) x nrow(X), where
the row is the DMU under observation and the columns the peers used for the Benchmark.}
\item{mus}{If WR != NULL, the estimated decision variables for the imposed weight restrictions
 are stored in a matrix with the dimensions nrow(X) x nrow(WR), where the rows are the DMUs and 
 columns the weight restrictions. If the values are positive, the WR is binding for the respective DMU.}
\item{slack}{If SLACK = TRUE, the slacks are estimated and stored in a matrix with the dimensions
nrow(X) x (ncol(X) + ncol(Y)). Showing the Slack of each DMU (row) for each input and output
(column).}
}
\description{
Hyperbolic DEA implementation including weight restrictions,
non-discretionary variables, gerenralized distance function, external referencing, estimation of slacks and
super-efficiency scores. The mathematical and theoretical foundations of the code are presented in the paper
"Data Envelopment Analysis and Hyperbolic Efficiency Measures: Extending Applications and Possiblities
for Between-Group Comparisons" (2023) by Alexander Öttl, Mette Asmild, and Daniel Gulde.
}
\examples{
X <- c(1,1,2,4,1.5,2,4,3)
Y <- c(1,2,4,4,0.5,2.5,3.5,4)
# we now impose linked weght restrictions. We assume outputs decrease by 
# four units when inputs are reduced by one. And we assume that outputs can
# can be increased by one when inputs are increased by four 

WR <- matrix(c(-4,-1,1,4), nrow = 2, byrow = TRUE)
hyperbolicDEA(X,Y,RTS="vrs", WR = WR)

# Another example having the same data but just estimate the results for DMU 1
# using XREF YREF and and a higher focus on inputs adjusting the ALPHA towards 0.
# Additionally, slacks are estimated.

hyperbolicDEA(X[1],Y[1],RTS="vrs", XREF = X, YREF = Y, WR = WR, ALPHA = 0.1, SLACK = TRUE)

}
