% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ff_set_threshold.R
\name{set_threshold}
\alias{set_threshold}
\title{Set a threshold}
\usage{
set_threshold(x, col_name, out_name = NULL, threshold, case = ">=")
}
\arguments{
\item{x}{data frame with class Date in the first column and
numeric on the others.}

\item{col_name}{string with column(s) name(s) where to apply the function.}

\item{out_name}{optional. String with new column(s) name(s). If you set it as \code{NULL},
the function will overwrite the original data frame.}

\item{threshold}{numeric vector with the threshold value(s).
If you provide a single value it will be recycled among \code{col_name} strings.}

\item{case}{string with either '>=' (greater or equal than) or '<=' (lesser or equal than)
symbol. Default string is '>='.}
}
\value{
The same data frame but with the threshold set.
}
\description{
Set tolerable extreme values (maximum or minimum). Records greater or
equal than ('>=') or lesser or equal than ('<=') 'threshold' argument are set
to \code{NA_real_}.
}
\examples{

# set path to file
path_file <- system.file('extdata', 'ianigla_cuevas.csv',
             package = 'hydrotoolbox')

# read with default names
cuevas <- read_ianigla(path = path_file,
                       out_name = c('tair(°C)', 'rh(\%)', 'patm(mbar)',
                                    'p(mm)', 'wspd(km/hr)', 'wdir(°)',
                                    'kin(kW/m2)', 'hsnow(cm)', 'tsoil(°C)') )

# remove values higher than 1.50 meters
cuevas \%>\%
  set_threshold(col_name = 'hsnow(cm)',
                out_name = 'hsnow_thres',
                threshold = 150 )


}
