% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dimnames.R
\name{add_colnames}
\alias{add_colnames}
\alias{add_rownames}
\title{Add column or row names}
\usage{
add_colnames(ht, rowname = NULL, ...)

add_rownames(ht, colname = "rownames", preserve_rownames = TRUE, ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{rowname}{Optional row name for the new row of column names.}

\item{...}{Arguments passed to methods.}

\item{colname}{Column name for the new column of row names.}

\item{preserve_rownames}{Preserve existing row names.}
}
\value{
The modified object.
}
\description{
Add a first row of column names, or a first column of row names, to the huxtable.
}
\details{
Note that \code{add_colnames} will change the mode of all columns to character. Also note that it will
move your rows down by one: what was row 1 will now be row 2, and the column names will now be row 1.

\code{add_colnames} preserves column names. \code{add_rownames} only preserves them if asked to.
}
\examples{
ht <- huxtable(
  First = rnorm(5),
  Second = rnorm(5),
  add_rownames = FALSE
)
add_rownames(ht)
add_colnames(ht)

# Out by 1:
add_rownames(add_colnames(ht))

# Better:
add_colnames(add_rownames(ht))

# Alternatively:
add_colnames(add_rownames(ht, ""))

}
