% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gfr_category.R
\name{get_gfr_category}
\alias{get_gfr_category}
\title{Categorize kidney function by GFR.}
\usage{
get_gfr_category(age_years, age_months, gfr_est)
}
\arguments{
\item{age_years}{Vector of ages in years.}

\item{age_months}{Vector of ages in months.}

\item{gfr_est}{Vector of estimated GFR values in mL/min/1.73m^2.}
}
\value{
Vector of GFR categories: 'Normal', 'Kidney Disease', 'Kidney
 Failure'.
}
\description{
For adults: 
In general GFR > 60 is considered normal 
15 < GFR < 60 is considered kidney disease 
GFR < 15 is considered kidney failure
}
\details{
These values can also be used for children 2 years old and greater (see PEDIATRICS IN
REVIEW Vol. 29 No. 10 October 1, 2008 pp. 335-341 (doi:
10.1542/pir.29-10-335))
}
\references{
\insertRef{ring2017identifying}{httk}
}
\author{
Caroline Ring
}
\keyword{httk-pop}
