% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_steadystate.R
\name{parameterize_steadystate}
\alias{parameterize_steadystate}
\title{Parameters for a three-compartment toxicokinetic model at steady-state}
\usage{
parameterize_steadystate(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  clint.pvalue.threshold = 0.05,
  default.to.human = FALSE,
  force.human.clint.fup = FALSE,
  adjusted.Funbound.plasma = TRUE,
  adjusted.Clint = TRUE,
  restrictive.clearance = TRUE,
  fup.lod.default = 0.005,
  suppress.messages = FALSE,
  minimum.Funbound.plasma = 1e-04,
  Caco2.options = NULL,
  ...
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{clint.pvalue.threshold}{Hepatic clearances with clearance assays
having p-values greater than the threshold are set to zero.}

\item{default.to.human}{Substitutes missing species-specific values with human values if
TRUE (default is FALSE).}

\item{force.human.clint.fup}{Uses human hepatic intrinsic clearance and fraction
of unbound plasma in calculation of partition coefficients for rats if true.}

\item{adjusted.Funbound.plasma}{Uses Pearce et al. (2017) lipid binding adjustment
for Funbound.plasma (which impacts partition coefficients) when set to TRUE (Default).}

\item{adjusted.Clint}{Uses Kilford et al. (2008) hepatocyte incubation
binding adjustment for Clint when set to TRUE (Default).}

\item{restrictive.clearance}{In calculating hepatic.bioavailability, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{fup.lod.default}{Default value used for fraction of unbound plasma for
chemicals where measured value was below the limit of detection. Default
value is 0.0005.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{Caco2.options}{A list of options to use when working with Caco2 apical to
basolateral data \code{Caco2.Pab}, default is Caco2.options = list(Caco2.Pab.default = 1.6,
Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.Pab.default sets the default value for 
Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}. Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.
See \code{\link{get_fabsgut}} for further details.}

\item{...}{Other parameters}
}
\value{
\item{Clint}{Hepatic Intrinsic Clearance, uL/min/10^6 cells.}
\item{Fabsgut}{Fraction of the oral dose absorbed and surviving gut metabolism, 
that is, the fraction of the dose that enters the gutlumen.}  
\item{Funbound.plasma}{Fraction of plasma that is not bound.} 
\item{Qtotal.liverc}{Flow rate of blood exiting the liver, L/h/kg BW^3/4.} 
\item{Qgfrc}{Glomerular Filtration Rate, L/h/kg
BW^3/4, volume of fluid filtered from kidney and excreted.} 
\item{BW}{Body Weight, kg} 
\item{MW}{Molecular Weight, g/mol}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.}
\item{Vliverc}{Volume of the liver per kg body weight, L/kg BW.}
\item{liver.density}{Liver tissue density, kg/L.}
\item{Fhep.assay.correction}{The fraction of chemical unbound in hepatocyte
assay using the method of Kilford et al. (2008)}
\item{hepatic.bioavailability}{Fraction of dose remaining after first pass
clearance, calculated from the corrected well-stirred model.}
}
\description{
This function initializes the parameters needed in the functions
\code{\link{calc_mc_css}}, \code{\link{calc_mc_oral_equiv}}, and 
\code{\link{calc_analytic_css}} for the three
compartment steady state model ('3compartmentss') as used in 
Rotroff et al. (2010), Wetmore et al. (2012), Wetmore et al. (2015), and 
elsewhere. By assuming that enough time has passed to reach steady-state, we
eliminate the need for tissue-specific parititon coefficients because we 
assume all tissues have come to equilibrium with the unbound concentration
in plasma. However, we still use chemical properties to predict the 
blood:plasma ratio for estimating first-pass hepatic metabolism for oral
exposures.
}
\details{
We model systemic oral bioavailability as 
\ifelse{html}{\out{F<sub>bio</sub>=F<sub>abs</sub>*F<sub>gut</sub>*F<sub>hep</sub>}}{\eqn{F_{bio}=F_{abs}*F_{gut}*F_{hep}}}.
\ifelse{html}{\out{F<sub>hep</sub>}}{\eqn{F_{hep}}}
is estimated from in vitro TK data using 
\code{\link{calc_hep_bioavailability}}.
If \ifelse{html}{\out{F<sub>bio</sub>}}{\eqn{F_{bio}}}
has been measured in vivo and is found in
table \code{\link{chem.physical_and_invitro.data}} then we set 
\ifelse{html}{\out{F<sub>abs</sub>*F<sub>gut</sub>}}{\eqn{F_{abs}*F_{git}}} 
to the measured value divided by 
\ifelse{html}{\out{F<sub>hep</sub>}}{\eqn{F_{hep}}} 
Otherwise, if Caco2 membrane permeability data or predictions
are available \ifelse{html}{\out{F<sub>abs</sub>}}{\eqn{F_{abs}}} is estimated
using \code{\link{calc_fabs.oral}}.
Intrinsic hepatic metabolism is used to very roughly estimate
\ifelse{html}{\out{F<sub>gut</sub>}}{\eqn{F_{gut}}}
using \code{\link{calc_fgut.oral}}.
}
\examples{

 parameters <- parameterize_steadystate(chem.name='Bisphenol-A',species='Rat')
 parameters <- parameterize_steadystate(chem.cas='80-05-7')

}
\references{
\insertRef{pearce2017httk}{httk}

\insertRef{kilford2008hepatocellular}{httk}
}
\seealso{
\code{\link{calc_analytic_css_3compss}}

\code{\link{apply_clint_adjustment}}

\code{\link{tissue.data}}

\code{\link{physiology.data}}
}
\author{
John Wambaugh and Greg Honda
}
\keyword{3compss}
