% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve_1comp.R
\name{solve_1comp}
\alias{solve_1comp}
\title{Solve one compartment TK model}
\usage{
solve_1comp(
  chem.name = NULL,
  chem.cas = NULL,
  dtxsid = NULL,
  times = NULL,
  parameters = NULL,
  days = 10,
  tsteps = 4,
  daily.dose = NULL,
  dose = NULL,
  doses.per.day = NULL,
  initial.values = NULL,
  plots = FALSE,
  suppress.messages = FALSE,
  species = "Human",
  iv.dose = FALSE,
  input.units = "mg/kg",
  output.units = NULL,
  method = "lsoda",
  rtol = 1e-08,
  atol = 1e-12,
  default.to.human = FALSE,
  recalc.blood2plasma = FALSE,
  recalc.clearance = FALSE,
  dosing.matrix = NULL,
  adjusted.Funbound.plasma = TRUE,
  regression = TRUE,
  restrictive.clearance = TRUE,
  minimum.Funbound.plasma = 1e-04,
  monitor.vars = NULL,
  Caco2.options = list(),
  ...
)
}
\arguments{
\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{times}{Optional time sequence for specified number of days.}

\item{parameters}{Chemical parameters from parameterize_1comp function,
overrides chem.name and chem.cas.}

\item{days}{Length of the simulation.}

\item{tsteps}{The number time steps per hour.}

\item{daily.dose}{Total daily dose, default is mg/kg BW.}

\item{dose}{Amount of a single dose, default is mg/kg BW.}

\item{doses.per.day}{Number of doses per day.}

\item{initial.values}{Vector containing the initial concentrations or
amounts of the chemical in specified tissues with units corresponding to
output.units.  Defaults are zero.}

\item{plots}{Plots all outputs if true.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", or default
"Human").}

\item{iv.dose}{Simulates a single i.v. dose if true.}

\item{input.units}{Input units of interest assigned to dosing, defaults to
"mg/kg" BW.}

\item{output.units}{A named vector of output units expected for the model
results. Default, NULL, returns model results in units specified in the
'modelinfo' file. See table below for details.}

\item{method}{Method used by integrator (deSolve).}

\item{rtol}{Argument passed to integrator (deSolve).}

\item{atol}{Argument passed to integrator (deSolve).}

\item{default.to.human}{Substitutes missing rat values with human values if
true.}

\item{recalc.blood2plasma}{Whether or not to recalculate the blood:plasma
chemical concentrationr ratio}

\item{recalc.clearance}{Whether or not to recalculate the elimination
rate.}

\item{dosing.matrix}{Vector of dosing times or a matrix consisting of two
columns or rows named "dose" and "time" containing the time and amount, in
mg/kg BW by default, of each dose.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE along with volume of distribution calculated with this value.}

\item{regression}{Whether or not to use the regressions in calculating
partition coefficients in volume of distribution calculation.}

\item{restrictive.clearance}{In calculating elimination rate, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}

\item{monitor.vars}{Which variables are returned as a function of time. 
Defaults value of NULL provides "Agutlumen", "Ccompartment", "Ametabolized",
"AUC"}

\item{Caco2.options}{A list of options to use when working with Caco2 apical to
basolateral data \code{Caco2.Pab}, default is Caco2.options = list(Caco2.default = 2,
Caco2.Fabs = TRUE, Caco2.Fgut = TRUE, overwrite.invivo = FALSE, keepit100 = FALSE). Caco2.default sets the default value for 
Caco2.Pab if Caco2.Pab is unavailable. Caco2.Fabs = TRUE uses Caco2.Pab to calculate
fabs.oral, otherwise fabs.oral = \code{Fabs}. Caco2.Fgut = TRUE uses Caco2.Pab to calculate 
fgut.oral, otherwise fgut.oral = \code{Fgut}. overwrite.invivo = TRUE overwrites Fabs and Fgut in vivo values from literature with 
Caco2 derived values if available. keepit100 = TRUE overwrites Fabs and Fgut with 1 (i.e. 100 percent) regardless of other settings.}

\item{...}{Additional arguments passed to the integrator.}
}
\value{
A matrix with a column for time(in days) and a column for the
compartment and the area under the curve (concentration only).
}
\description{
This function solves for the amount or concentration of a chemical in plasma
for a one compartment model as a function of time based on the dose and
dosing frequency.
}
\details{
Note that the timescales for the model parameters have units of hours while 
the model output is in days.

Default value of NULL for doses.per.day solves for a single dose.

When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitutes human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.

AUC is area under plasma concentration curve.

Model Figure 
\if{html}{\figure{1comp.png}{options: width="60\%" alt="Figure: One
Compartment Model Schematic"}}
\if{latex}{\figure{1comp.pdf}{options: width=12cm alt="Figure: One
Compartment Model Schematic"}}
}
\examples{

solve_1comp(chem.name='Bisphenol-A', days=1)

# By storing the model parameters in a vector first, you can potentially
# edit them before using the model:
params <- parameterize_1comp(chem.cas="80-05-7")
solve_1comp(parameters=params, days=1)

head(solve_1comp(chem.name="Terbufos", daily.dose=NULL, dose=1, days=1))
head(solve_1comp(chem.name="Terbufos", daily.dose=NULL,
                 dose=1,days=1, iv.dose=TRUE))

# A dose matrix specifies times and magnitudes of doses:
dm <- matrix(c(0,1,2,5,5,5),nrow=3)
colnames(dm) <- c("time","dose")
solve_1comp(chem.name="Methenamine", dosing.matrix=dm,
            days=2.5, dose=NULL,daily.dose=NULL)

solve_1comp(chem.name="Besonprodil", daily.dose=1, dose=NULL,
            days=2.5, doses.per.day=4)

}
\references{
\insertRef{pearce2017httk}{httk}
}
\seealso{
\code{\link{solve_model}}

\code{\link{parameterize_1comp}}

\code{\link{calc_analytic_css_1comp}}
}
\author{
Robert Pearce
}
\keyword{1compartment}
\keyword{Solve}
