% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{httk.performance}
\alias{httk.performance}
\title{Historical Performance of R Package httk}
\format{
An object of class \code{data.frame} with 22 rows and 18 columns.
}
\usage{
httk.performance
}
\description{
This table records the historical performance and other metrics 
of the R package "httk" as
profiled with the function \code{\link{benchmark_httk}}. There is a row for
each version and a column for each benchmark or metric. This table is used
to generate graphs comparing the current version to past performance in order
to help identify unintended degradtion of package capabilities.
}
\details{
\tabular{ll}{
\strong{Column Name} \tab \strong{Description} \cr
 Version \tab The release of httk (major.minor.patch) \cr                      
 N.steadystate \tab The number of chemicals for which Css can be predicted for the steady-state model \cr
 calc_analytic.units \tab The ratio of the output of \code{\link{calc_analytic_css}} in mg/L to uM multiplied by 1000/MW (should be 1)\cr
 calc_mc.units  \tab The ratio of the output of \code{\link{calc_mc_css}} in mg/L to uM multiplied by 1000/MW (should be 1) \cr
 solve_pbtk.units  \tab The ratio of a Cplasma value from \code{\link{solve_pbtk}} in mg/L to uM multiplied by 1000/MW (should be 1) \cr  
 RMSLE.Wetmore \tab Root mean squared log10 error between Css predictions from httk and published values from Wetmore papers (both 95th percentile) \cr
 N.Wetmore  \tab  Number of chemicals used in RMSLE evaluation \cr          
 RMSLE.noMC  \tab  RMSLE between 95th percentile Css prediction and median prediction \cr 
 N.noMC  \tab Number of chemicals used in RMSLE evaluation \cr 
 RMSLE.InVivoCss  \tab RMSLE for predictions of in vivo measured Css \cr 
 N.InVivoCss  \tab Number of chemicals used in RMSLE evaluation  \cr 
 RMSLE.InVivoAUC   \tab RMSLE for predictions of in vivo measured AUCs \cr 
 N.InVivoAUC  \tab Number of chemicals used in RMSLE evaluation \cr 
 RMSLE.InVivoCmax \tab RMSLE for predictions of in vivo measured Cmax \cr 
 N.InVivoCmax  \tab Number of chemicals used in RMSLE evaluation \cr 
 RMSLE.TissuePC \tab RMSLE for predicted tissue:plasma partition coefficients \cr  
 N.TissuePC  \tab Number of chemicals used in RMSLE evaluation \cr                
 Notes  \tab Why benchmarks/metrics may have changed \cr       
}
}
\references{
\insertRef{DavidsonFritzUnpublishedModelAdding}{httk}
}
\seealso{
\code{\link{benchmark_httk}}
}
\keyword{datasets}
