% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/httkpop_mc.R
\name{httkpop_mc}
\alias{httkpop_mc}
\title{Converts the HTTK-Pop population data table to a table of the parameters
needed by HTTK, for a specific chemical.}
\usage{
httkpop_mc(model, samples = 1000, httkpop.dt = NULL, ...)
}
\arguments{
\item{model}{One of the HTTK models: "1compartment", "3compartmentss",
"3compartment", or "pbtk".}

\item{samples}{The number of Monte Carlo samples to use (can often think of these
as separate individuals)}

\item{httkpop.dt}{A data table generated by \code{\link{httkpop_generate}}.
This defaults to NULL, in which case \code{\link{httkpop_generate}} is 
called to generate this table.}

\item{...}{Additional arugments passed on to \code{\link{httkpop_generate}}.}
}
\value{
A data.table with a row for each individual in the sample and a column for
each parater in the model.
}
\description{
Takes the data table generated by \code{\link{httkpop_generate}}, and converts it
to the corresponding table of HTTK model parameters for a specified chemical
and HTTK model.
}
\examples{

set.seed(42)
indiv_examp <- httkpop_generate(method="d", nsamp=100)
httk_param <- httkpop_mc(httkpop.dt=indiv_examp, 
model="1compartment")

}
\references{
Ring, Caroline L., et al. "Identifying populations sensitive to
environmental chemicals by simulating toxicokinetic variability."
Environment International 106 (2017): 105-118

Rowland, Malcolm, Leslie Z. Benet, and Garry G. Graham. "Clearance concepts
in pharmacokinetics." Journal of Pharmacokinetics and Biopharmaceutics 1.2
(1973): 123-136.
}
\author{
Caroline Ring and John Wambaugh
}
\keyword{httk-pop}
\keyword{monte-carlo}
