% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{chem.physical_and_invitro.data}
\alias{chem.physical_and_invitro.data}
\title{Physico-chemical properties and in vitro measurements for toxicokinetics}
\format{
A data.frame containing 565 rows and 33 columns.
}
\source{
Wambaugh, John F., et al. "Toxicokinetic triage for environmental
chemicals." Toxicological Sciences (2015): 228-237.
}
\usage{
chem.physical_and_invitro.data
}
\description{
This data set contains the necessary information to make basic,
high-throughput toxicokinetic (HTTK) predictions for compounds, including
Funbound.plasma, molecular weight (g/mol), logP, logMA (membrane affinity),
intrinsic clearance(uL/min/10^6 cells), and pKa. These data have been
compiled from multiple sources, and can be used to parameterize a variety of
toxicokinetic models. See variable EPA.ref for information on the reference EPA.
}
\references{
DSStox database (https:// www.epa.gov/ncct/dsstox

EPI Suite, https://www.epa.gov/opptintr/exposure/pubs/episuite.htm

Hilal, S., Karickhoff, S. and Carreira, L. (1995). A rigorous test for
SPARC's chemical reactivity models: Estimation of more than 4300 ionization
pKas. Quantitative Structure-Activity Relationships 14(4), 348-355.

Honda, G. S., Pearce, R. G., Pham, L. L., Setzer, R. W., Wetmore, B. A., 
Sipes, N. S., ... & Wambaugh, J. F. (2019). Using the concordance of in 
vitro and in vivo data to evaluate extrapolation assumptions. PloS one, 
14(5), e0217564.

Ito, K. and Houston, J. B. (2004). Comparison of the use of liver models for
predicting drug clearance using in vitro kinetic data from hepatic
microsomes and isolated hepatocytes. Pharm Res 21(5), 785-92.

Jones, O. A., Voulvoulis, N. and Lester, J. N. (2002). Aquatic environmental
assessment of the top 25 English prescription pharmaceuticals. Water
research 36(20), 5013-22.

Lau, Y. Y., Sapidou, E., Cui, X., White, R. E. and Cheng, K. C. (2002).
Development of a novel in vitro model to predict hepatic clearance using
fresh, cryopreserved, and sandwich-cultured hepatocytes. Drug Metabolism and
Disposition 30(12), 1446-54.

Linakis, M. W., Sayre, R. R., Pearce, R. G., Sfeir, M. A., Sipes, N. S., 
Pangburn, H. A., ... & Wambaugh, J. F. (2020). Development and evaluation of 
a high throughput inhalation model for organic chemicals. Journal of 
Exposure Science & Environmental Epidemiology, 1-12.

Lombardo, F., Berellini, G., & Obach, R. S. (2018). Trend analysis of a 
database of intravenous pharmacokinetic parameters in humans for 1352 drug 
compounds. Drug Metabolism and Disposition, 46(11), 1466-1477.

McGinnity, D. F., Soars, M. G., Urbanowicz, R. A. and Riley, R. J. (2004).
Evaluation of fresh and cryopreserved hepatocytes as in vitro drug
metabolism tools for the prediction of metabolic clearance. Drug Metabolism
and Disposition 32(11), 1247-53, 10.1124/dmd.104.000026.

Naritomi, Y., Terashita, S., Kagayama, A. and Sugiyama, Y. (2003). Utility
of Hepatocytes in Predicting Drug Metabolism: Comparison of Hepatic
Intrinsic Clearance in Rats and Humans in Vivo and in Vitro. Drug Metabolism
and Disposition 31(5), 580-588, 10.1124/dmd.31.5.580.

Obach, R. S. (1999). Prediction of human clearance of twenty-nine drugs from
hepatic microsomal intrinsic clearance data: An examination of in vitro
half-life approach and nonspecific binding to microsomes. Drug Metabolism
and Disposition 27(11), 1350-9.

Paini, Alicia; Cole, Thomas; Meinero, Maria; Carpi, Donatella; Deceuninck, 
Pierre; Macko, Peter; Palosaari, Taina; Sund, Jukka; Worth, Andrew; Whelan, 
Maurice (2020):  EURL ECVAM in vitro hepatocyte clearance and blood plasma 
protein binding dataset for 77 chemicals. European Commission, Joint Research 
Centre (JRC) [Dataset] PID: https://data.europa.eu/89h/a2ff867f-db80-4acf-8e5c-e45502713bee

Paixao, P., Gouveia, L. F., & Morais, J. A. (2012). Prediction of the human
oral bioavailability by using in vitro and in silico drug related parameters
in a physiologically based absorption model. International journal of
pharmaceutics, 429(1), 84-98.

Pirovano, Alessandra, et al. "QSARs for estimating intrinsic hepatic
clearance of organic chemicals in humans." Environmental toxicology and
pharmacology 42 (2016): 190-197.

Schmitt, W. (2008). General approach for the calculation of tissue to plasma
partition coefficients. Toxicology in vitro : an international journal
published in association with BIBRA 22(2), 457-67,
10.1016/j.tiv.2007.09.010.

Shibata, Y., Takahashi, H., Chiba, M. and Ishii, Y. (2002). Prediction of
Hepatic Clearance and Availability by Cryopreserved Human Hepatocytes: An
Application of Serum Incubation Method. Drug Metabolism and Disposition
30(8), 892-896, 10.1124/dmd.30.8.892.

Tonnelier, A., Coecke, S. and Zaldivar, J.-M. (2012). Screening of chemicals
for human bioaccumulative potential with a physiologically based
toxicokinetic model. Archives of Toxicology 86(3), 393-403,
10.1007/s00204-011-0768-0.

Uchimura, Takahide, et al. "Prediction of human blood-to-plasma drug
concentration ratio." Biopharmaceutics & drug disposition 31.5-6 (2010):
286-297.

Wambaugh, J. F., Wetmore, B. A., Ring, C. L., Nicolas, C. I., Pearce, R. G., 
Honda, G. S., ... & Badrinarayanan, A. (2019). Assessing Toxicokinetic 
Uncertainty and Variability in Risk Prioritization. Toxicological Sciences, 
172(2), 235-251.

Wetmore, B. A., Wambaugh, J. F., Ferguson, S. S., Sochaski, M. A., Rotroff,
D. M., Freeman, K., Clewell, H. J., 3rd, Dix, D. J., Andersen, M. E., Houck,
K. A., Allen, B., Judson, R. S., Singh, R., Kavlock, R. J., Richard, A. M.
and Thomas, R. S. (2012). Integration of dosimetry, exposure, and
high-throughput screening data in chemical toxicity assessment.
Toxicological sciences : an official journal of the Society of Toxicology
125(1), 157-74, 10.1093/toxsci/kfr254.

Wetmore, B. A., Wambaugh, J. F., Ferguson, S. S., Li, L., Clewell, H. J.,
Judson, R. S., Freeman, K., Bao, W., Sochaski, M. A., Chu, T.-M., Black, M.
B., Healy, E., Allen, B., Andersen, M. E., Wolfinger, R. D. and Thomas, R.
S. (2013). Relative Impact of Incorporating Pharmacokinetics on Predicting
In Vivo Hazard and Mode of Action from High-Throughput In Vitro Toxicity
Assays. Toxicological Sciences 132(2), 327-346, 10.1093/toxsci/kft012.

Wetmore, B. A., Wambaugh, J. F., Allen, B., Ferguson, S. S., Sochaski, M.
A., Setzer, R. W., Houck, K. A., Strope, C. L., Cantwell, K., Judson, R. S.,
LeCluyse, E., Clewell, H.J. III, Thomas, R.S., and Andersen, M. E. (2015).
"Incorporating High-Throughput Exposure Predictions with Dosimetry-Adjusted
In Vitro Bioactivity to Inform Chemical Toxicity Testing" Toxicological
Sciences, kfv171.
}
\author{
John Wambaugh
}
\keyword{data}
