% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_pbtk_sbml.R
\name{export_pbtk_sbml}
\alias{export_pbtk_sbml}
\title{Export model to sbml.}
\usage{
export_pbtk_sbml(
  chem.cas = NULL,
  chem.name = NULL,
  species = "Human",
  initial.amounts = list(Agutlumen = 0),
  filename = "default.xml",
  digits = 4
)
}
\arguments{
\item{chem.cas}{Either the chemical name or CAS number must be specified.}

\item{chem.name}{Either the chemical name or CAS number must be specified.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", or default
"Human").}

\item{initial.amounts}{Must specify initial amounts in units of choice.}

\item{filename}{The name of the jarnac file containing the model.}

\item{digits}{Desired number of decimal places to round the parameters.}
}
\description{
This function exports the multiple compartment PBTK model to an sbml file.
}
\details{
Compartments to enter into the initial.amounts list includes Agutlumen,
Aart, Aven, Alung, Agut, Aliver, Akidney, and Arest.

When species is specified as rabbit, dog, or mouse, the function uses the
appropriate physiological data(volumes and flows) but substitues human
fraction unbound, partition coefficients, and intrinsic hepatic clearance.
}
\examples{

\dontrun{
export_pbtk_sbml(chem.name='Nicotine',initial.amounts=list(Agutlumen=1),filename='PBTKmodel.xml')
}

}
\author{
Robert Pearce
}
\keyword{Export}
