% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_schmitt.R
\name{parameterize_schmitt}
\alias{parameterize_schmitt}
\title{Parameterize Schmitt's method.}
\usage{
parameterize_schmitt(chem.cas = NULL, chem.name = NULL,
  species = "Human", default.to.human = F, force.human.fup = F,
  suppress.messages = F, minimum.Funbound.plasma = 1e-04)
}
\arguments{
\item{chem.cas}{Either the chemical name or the CAS number must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{default.to.human}{Substitutes missing fraction of unbound plasma with
human values if true.}

\item{force.human.fup}{Returns human fraction of unbound plasma in
calculation for rats if true.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}
}
\value{
\item{Funbound.plasma}{corrected unbound fraction in plasma}
\item{unadjusted.Funbound.plasma}{measured unbound fraction in plasma (0.005
if below limit of detection)} \item{Pow}{octonol:water partition coefficient
(not log transformed)} \item{pKa_Donor}{compound H dissociation equilibirum
constant(s)} \item{pKa_Accept}{compound H association equilibirum
constant(s)} \item{MA}{phospholipid:water distribution coefficient, membrane
affinity} \item{Fprotein.plasma}{protein fraction in plasma}
\item{plasma.pH}{pH of the plasma}
}
\description{
This function provides the necessary parameters to run
predict_partitioning_schmitt, excluding the data in tissue.data.
}
\details{
When species is specified as rabbit, dog, or mouse, the human unbound
fraction is substituted.

force.human.fup calculates Funbound.plasma.corrected with the human lipid
fractional volume in plasma.
}
\examples{

parameterize_schmitt(chem.name='bisphenola')

}
\author{
Robert Pearce
}
\keyword{Parameter}
