% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmltreeview.R
\name{xml_tree_view}
\alias{xml_tree_view}
\alias{html_tree_view}
\title{HTML/XML tree viewer}
\usage{
xml_tree_view(doc = NULL, scroll = FALSE, elementId = NULL,
  width = "100\%", height = NULL)

html_tree_view(doc = NULL, scroll = FALSE, elementId = NULL,
  width = "100\%", height = NULL)
}
\arguments{
\item{doc}{\code{xml2} document/node/nodeset, an \code{HTMLInternalDocument}/
\code{XMLInternalDocument} or atomic character vector of HTML/XML content}

\item{scroll}{should the \code{<div>} holding the HTML/XML content scroll
(\code{TRUE}) or take up the full viewer/browser window (\code{FALSE}).
Default is \code{FALSE} (take up the full viewer/browser window). If
this is set to \code{TRUE}, \code{height} should be set to a value
other than \code{NULL}.}

\item{elementId}{element id}

\item{width}{widget \code{div} width}

\item{height}{widget \code{div} height}
}
\description{
This uses the \code{xml-viewer} JavaScript module to provide a simple collapsible
tree viewer for HTML/XML documents, nodes, node sets and plain character
HTML/XML in an \code{htmlwidget} pane.
}
\note{
Large HTML or XML content may take some time to render properly. It is suggested
      that this function be used on as minimal of a subset of HTML/XML as possible
      or used in a browser context vs an IDE viewer context.
}
\examples{
if (interactive()) {

# from ?xml2::read_xml
cd <- xml2::read_xml("http://www.xmlfiles.com/examples/cd_catalog.xml")

xml_tree_view(cd)

htmltools::browsable(
  htmltools::tagList(
    xml_tree_view(cd, width = "100\%", height = "300px"),
    xml_view(cd)
  )
)
}
}
\references{
\href{https://github.com/juliangruber/xml-viewer}{xml-viewer}
}
