% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projection.R
\name{projsel}
\alias{projsel}
\title{Forward selection minimizing KL-divergence in projection}
\usage{
projsel(obj, max.iters = 30, out.csv = NULL)
}
\arguments{
\item{obj}{Object of class \code{hsstan}.}

\item{max.iters}{Maximum number of iterations (number of predictors selected)
after which the selection procedure should stop.}

\item{out.csv}{If not \code{NULL}, the name of a CSV file to save the
output to.}
}
\value{
A data frame of class \code{projsel} where each row corresponds to a
forward-selected submodel that contains all variables listed up to that row.
The data frame contains the following columns:
\item{var}{names of the variables selected.}
\item{kl}{KL-divergence from the full model to the submodel.}
\item{rel.kl.null}{relative explanatory power of predictors starting from the
intercept-only model.}
\item{rel.kl}{relative explanatory power of predictors starting from the model
containing unpenalized covariates.}
\item{elpd}{the expected log predictive density of the submodels.}
\item{delta.elpd}{the difference in elpd from the full model.}
}
\description{
Forward selection minimizing KL-divergence in projection
}
\examples{
\donttest{
\dontshow{utils::example("hsstan", echo=FALSE)}
\dontshow{oldopts <- options(mc.cores=2)}
# continued from ?hsstan

sel <- projsel(hs.biom, max.iters=3)
plot(sel)
\dontshow{options(oldopts)}
}

}
