% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LDHScpp}
\alias{LDHScpp}
\title{Expectation Maximisation (EM) algorithm}
\usage{
LDHScpp(XGF1, XGF2, fAA, fAB, fBA, theta, display, threshold)
}
\arguments{
\item{XGF1}{integer matrix of progeny genotypes in genomic family 1}

\item{XGF2}{integer matrix of progeny genotypes in genomic family 2}

\item{fAA}{frequency of maternal haplotype 1-1}

\item{fAB}{frequency of maternal haplotype 1-0}

\item{fBA}{frequency of maternal haplotype 0-1}

\item{theta}{paternal recombination rate}

\item{display}{logical for displaying additional information}

\item{threshold}{convergence criterion}
}
\value{
list of parameter estimates
\describe{
 \item{\code{D}}{maternal LD}
 \item{\code{fAA}}{frequency of maternal haplotype 1-1}
 \item{\code{fAB}}{frequency of maternal haplotype 1-0}
 \item{\code{fBA}}{frequency of maternal haplotype 0-1}
 \item{\code{fBB}}{frequency of maternal haplotype 0-0}
 \item{\code{p1}}{Maternal allele frequency (allele 1)}
 \item{\code{p2}}{Maternal allele frequency (allele 0)}
 \item{\code{nfam1}}{size of genomic family 1}
 \item{\code{nfam2}}{size of genomic family 2}
 \item{\code{error}}{0 if computations were without error; 1 if EM algorithm
  did not converge}
 \item{\code{iteration}}{number of EM iterations}
 \item{\code{theta}}{paternal recombination rate}
 \item{\code{r2}}{\eqn{r^2} of maternal LD}
 \item{\code{logL}}{value of log likelihood function}
}
}
\description{
Expectation Maximisation (EM) algorithm
}
