% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rtCreateTrans.R
\name{rtCreateTrans}
\alias{rtCreateTrans}
\title{Create transaction data for rt approach}
\usage{
rtCreateTrans(trans_df, prop_id, trans_id, price, date = NULL,
  periodicity = NULL, seq_only = FALSE, min_period_dist = NULL, ...)
}
\arguments{
\item{trans_df}{transactions in either a data.frame or a `hpidata`` class from
dateToPeriod() function}

\item{prop_id}{field contain the unique property identification}

\item{trans_id}{field containing the unique transaction identification}

\item{price}{field containing the transaction price}

\item{date}{default=NULL, field containing the date of the sale.
Only necessary if not passing an `hpidata` object}

\item{periodicity}{default=NULL, field containing the desired periodicity of analysis.
Only necessary if not passing a `hpidata` object}

\item{seq_only}{default=FALSE, indicating whether to only include sequential repeat observations
1 to 2 and 2 to 3.  False returns 1 to 2, 1 to 3 and 2 to 3.}

\item{min_period_dist}{[12] Minimum number of period required between repeat sales}

\item{...}{Additional arguments}
}
\value{
data.frame of repeat transactions. Note that a full data.frame of the possible
periods, their values and names can be found in the attributes to the returned `rtdata` object
}
\description{
Generate standardized object for rt estimate approach
}
\section{Further Details}{

Properties with greater than two transactions during the period will make pairwise matches
among all sales.  Any property transacting twice in the same period will remove the lower
priced of the two transactions.
If passing a raw data.frame (not a `hpidata`` object) the "date" field should refer to
a field containing a vector of class POSIXt or Date.
}

\examples{

 # Load data
 data(ex_sales)

 # With a raw transaction data.frame
 rt_data <- rtCreateTrans(trans_df = ex_sales,
                          prop_id = 'pinx',
                          trans_id = 'sale_id',
                          price = 'sale_price',
                          periodicity = 'monthly',
                          date = 'sale_date')

}
