% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcRevision.R
\name{calcRevision}
\alias{calcRevision}
\title{Calculate revision values of an index}
\usage{
calcRevision(series_obj, in_place = FALSE, in_place_name = "rev",
  smooth = FALSE, ...)
}
\arguments{
\item{series_obj}{A list of progressively longer indexes (a `serieshpi`` object from
`createSeries()``)}

\item{in_place}{default = FALSE; Calculating in place (adding to hpi)}

\item{in_place_name}{default = 'rev'; Name of revision object in_place}

\item{smooth}{default = FALSE; Use smoothed indexes}

\item{...}{Additional Arguments}
}
\value{
list of length 3 containing:
\describe{
  \item{period}{Data.frame containing the period number, mean and median for that period}
  \item{mean}{Mean revision for all periods}
  \item{median}{Median revision for all periods}
}
}
\description{
Create estimates of the revision statistics for a house price index
}
\section{Further Details}{

The revision object can be generate "in place" inside of the `serieshpi` object by
setting `in_place` equal to TRUE.
}

\examples{

# Load example sales
 data(ex_sales)

 # Create Index
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Create Series (Suppressing messages do to small sample size of this example)
  suppressMessages(
    hpi_series <- createSeries(hpi_obj = rt_index,
                               train_period = 12))

 # Calculate revision
 series_rev <-  calcRevision(series_obj = hpi_series)

}
