#' Simplified polygons of New Zealand.
#'
#' A dataset containing sf::MULTIPOLYGONS for New Zealand. Simplified version of
#' Stats NZ data, at 1km resolution. Called 'coast' but contains a bit more detail.
#'
#' @format MULTIPOLYGON projected into \code{\link{crs_Pacific}}
#'
#' @seealso \code{\link{NZ_buffer30}}
#'
#' @source
#'   \url{https://datafinder.stats.govt.nz/layer/104266-territorial-authority-2020-clipped-generalised/}
#'
"NZ_coast"

#' New Zealand polygons with 30km land buffer
#'
#' A dataset containing sf::MULTIPOLYGONS for New Zealand. Uses simplified
#' version of Stats NZ data, at 1km resolution, as in \code{\link{NZ_coast}}, with added 30km
#' buffer to all coasts.
#'
#' @format MULTIPOLYGON projected into \code{\link{crs_Pacific}}
#'
#' @seealso \code{\link{NZ_coast}}, \code{\link{NZ_Buller_buffer40}}
#'
#' @source
#'   \url{https://datafinder.stats.govt.nz/layer/104266-territorial-authority-2020-clipped-generalised/}
#'
"NZ_buffer30"

#' New Zealand Buller district plus 40km buffer
#'
#' Chosen purely for convenience of examples, a subset of \code{\link{NZ_coast}} for
#' Buller District only to which a buffer of 40km has been added. This forces
#' deviation in routes, when used as an 'avoid' dataset.
#'
#' @format MULTIPOLYGON projected into \code{\link{crs_Pacific}}
#'
#' @seealso \code{\link{NZ_coast}}
#'
#' @source
#' \url{https://datafinder.stats.govt.nz/layer/104266-territorial-authority-2020-clipped-generalised/}
#'
"NZ_Buller_buffer40"

#' Lat-long coordinate reference system
#'
#' Coordinate reference system (CRS) for creating maps from
#' longitude-latitude coordinates. Used in analysis, but
#' not recommended for plots.
#'
#' \code{crs_longlat} is EPSG4326
#'
#' @seealso \code{\link{crs_Atlantic}}, \code{\link{crs_Pacific}},
#'  \code{\link{crs_S}}, \code{\link{crs_N}}
#'
#' @format CRS
#'
"crs_longlat"

#' Atlantic-centred coordinate reference system
#'
#' Coordinate reference system (CRS) for plotting and analysing maps.
#' Atlantic-centred. Works for most analysis, but not recommended for N-region
#' (eg New Zealand and Fiji), instead use \code{\link{crs_Pacific}}.
#'
#' crs_Atlantic is "+proj=robin +lon_0=0 +x_0=0 +y_0=0 +ellps=WGS84
#' +datum=WGS84 +units=m +no_defs"
#'
#' @seealso \code{\link{crs_Pacific}}, \code{\link{crs_N}}, \code{\link{crs_S}}
#'
#' @format CRS
#'
"crs_Atlantic"

#' Pacific-centred coordinate reference system
#'
#' Coordinate reference system (CRS) for plotting and analysing maps.
#' Pacific-centred.
#'
#' "+proj=robin +lon_0=180 +x_0=0 +y_0=0 +ellps=WGS84 +datum=WGS84 +units=m +no_defs"
#'
#' @format CRS
#'
#' @seealso \code{\link{crs_Atlantic}}, \code{\link{crs_N}}, \code{\link{crs_S}}
#'
"crs_Pacific"

#' Arctic-centred coordinate reference system
#'
#' Coordinate reference system (CRS) for plotting and analysing maps.
#' WGS 84 / Arctic Polar Stereographic. Used in analysis, but
#' not recommended for plots.
#'
#' crs_N is EPSG3995
#'
#' @seealso \code{\link{crs_Atlantic}}, \code{\link{crs_Pacific}},
#'  \code{\link{crs_longlat}}, \code{\link{crs_S}}
#'
#' @format CRS
#'
"crs_N"

#' Antarctic-centred coordinate reference system
#'
#' Coordinate reference system (CRS) for plotting and analysing maps.
#' WGS 84 / Antarctic Polar Stereographic. Used in analysis, but
#' not recommended for plots.
#'
#' crs_N is EPSG 3031
#'
#' @seealso \code{\link{crs_Atlantic}}, \code{\link{crs_Pacific}},
#'  \code{\link{crs_longlat}}, \code{\link{crs_N}}
#'
#' @format CRS
#'
"crs_S"


#' Speed of sound, for Mach to km conversion
#'
#' 1 Mach is approximately 1062kph in standard met conditions at the altitude
#' for supersonic flight (approx 50,000 feet).
#'
#' @format double
#'
"mach_kph"


#' 30km routing grid around New Zealand
#'
#' Latitude-longitude-based routing grid around New Zealand at 30km target
#' distance, as generated by \code{\link{make_route_grid}}.
#'
#' Uses built-in map \code{\link{NZ_buffer30}} projected to
#' \code{\link{crs_Pacific}}.
#'
#' @format \linkS4class{GridLat}
#'
"NZ_grid"


#' 5 example routes around New Zealand
#'
#' Some very unlikely supersonic routes around New Zealand using the test
#' aircraft that was given a very short range and slow subsonic cruise to get
#' the example to 'work'. [Not for operational use!]
#'
#' Includes one refuelling stop (!) in Wellington.
#'
#' Generated by \code{\link{find_route}}. Uses built-in map
#' \code{\link{NZ_buffer30}}.
#'
#' @format dataframe with 49 fields.
#'
"NZ_routes"

