% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_inject.r
\name{table_id_inject}
\alias{table_id_inject}
\title{Table hash addition}
\usage{
table_id_inject(x, id, conditions, variable = NULL)
}
\arguments{
\item{x}{A table object}

\item{id}{A vector of css id(s) to include}

\item{conditions}{A vector of conditions to include id. Must be same length as id}

\item{variable}{An optional list of column names to specify search of conditions. More
than one variable can be specified in each element of the list. The list must be the 
same length as the conditions or id arguments.}
}
\description{
A helper function to include a hashtag id code within an R table.
}
\examples{
library(dplyr)
library(highlightHTML)

summ_table <- mtcars \%>\% 
  group_by(cyl) \%>\% 
  summarise(avg_mpg = mean(mpg), sd_mpg = sd(mpg)) \%>\%
  data.frame()
  
table_id_inject(summ_table, id = c('#bgred', '#bgblue'), 
  conditions = c('< 2', '> 16'))
  
table_id_inject(summ_table, id = c('#bgred', '#bgblue'),
  conditions = c('< 2', '< 16'), 
  variable = list(c('sd_mpg'), c('avg_mpg')))  
  
}

