% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{autoSelectExchangeTrades}
\alias{autoSelectExchangeTrades}
\title{Retain only data from the stock exchange with the highest trading volume}
\usage{
autoSelectExchangeTrades(tData, printExchange = TRUE)
}
\arguments{
\item{tData}{an \code{xts} object with at least a column \code{"EX"} 
indicating the exchange symbol and \code{"SIZE"}
indicating the trade volume.}

\item{printExchange}{indicates whether the chosen exchange is printed on the console, default is \code{TRUE}.
The possible exchanges are:
\itemize{
\item A: AMEX
\item N: NYSE
\item B: Boston
\item P: Arca
\item C: NSX
\item T/Q: NASDAQ
\item D: NASD ADF and TRF
\item X: Philadelphia
\item I: ISE
\item M: Chicago
\item W: CBOE
\item Z: BATS
}}
}
\value{
\code{data.table} or \code{xts} object depending on input.
}
\description{
Filters raw trade data and return only data that stems from the exchange with the highest
 value for the variable \code{"SIZE"}, i.e. the highest trade volume.
}
\examples{
autoSelectExchangeTrades(sampleTDataRaw)

}
\author{
Jonathan Cornelissen, Kris Boudt, Onno Kleen, and Emil Sjoerup.
}
\keyword{cleaning}
