% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realizedMeasuresInference.R
\name{IVinference}
\alias{IVinference}
\title{Function returns the value, the standard error and the confidence band of the integrated variance (IV) estimator.}
\usage{
IVinference(
  rData,
  IVestimator = "RV",
  IQestimator = "rQuar",
  confidence = 0.95,
  alignBy = NULL,
  alignPeriod = NULL,
  makeReturns = FALSE,
  ...
)
}
\arguments{
\item{rData}{\code{xts} object containing all returns in period t for one asset.}

\item{IVestimator}{can be chosen among integrated variance estimators: RV, BV, rMinRV or rMedRV. RV by default.}

\item{IQestimator}{can be chosen among integrated quarticity estimators: rQuar, realized tri-power quarticity (TPQ), quad-power quarticity (QPQ), rMinRQ or rMedRQ. TPQ by default.}

\item{confidence}{confidence level set by users. 0.95 by default.}

\item{alignBy}{character, indicating the time scale in which \code{alignPeriod} is expressed. Possible values are: "secs", "seconds", "mins", "minutes","hours".
To aggregate based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. E.g. to aggregate
based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to \code{"minutes"}.}

\item{makeReturns}{boolean, should be \code{TRUE} when \code{rData} contains prices instead of returns. \code{FALSE} by default.}

\item{...}{additional arguments.}
}
\value{
list
}
\description{
This function supplies information about standard error and confidence band of integrated variance (IV) estimators under Brownian semimartingales model such as: bipower variation, rMinRV, rMedRV. 
Depending on users' choices of estimator (integrated variance (IVestimator), integrated quarticity (IQestimator)) and confidence level, the function returns the result.(Barndorff (2002))
Function returns three outcomes: 1.value of IV estimator 2.standard error of IV estimator and 3.confidence band of IV estimator. 

Assume there is \eqn{N} equispaced returns in period \eqn{t}.

Then the IVinference is given by: 
\deqn{
\mbox{standard error}= \frac{1}{\sqrt{N}} *sd
}
\deqn{
\mbox{confidence band}= \hat{IV} \pm cv*se
}
in which,
\deqn{
\mbox{sd}= \sqrt{\theta \times \hat{IQ}} 
}

\eqn{cv:} critical value. 

\eqn{se:} standard error.

\eqn{\theta:} depending on IQestimator, \eqn{\theta} can take different value (Andersen et al. (2012)). 

\eqn{\hat{IQ}} integrated quarticity estimator.
}
\details{
The theoretical framework is the logarithmic price process \eqn{X_t} belongs to the class of Brownian semimartingales, which can be written as:
\deqn{
\mbox{X}_{t}=  \int_{0}^{t} a_udu + \int_{0}^{t}\sigma_{u}dW_{u}
}
where \eqn{a} is the drift term, \eqn{\sigma} denotes the spot vivInferenceolatility process, \eqn{W} is a standard Brownian motion (assume that there are no jumps).
}
\examples{
\dontrun{
library("xts") # This function only accepts xts data currently
ivInf <- IVinference(as.xts(sampleTData[, list(DT, PRICE)]), IVestimator= "rMinRV",
                     IQestimator = "rMedRQ", confidence = 0.95, makeReturns = TRUE)
ivInf
}
            
}
\references{
Andersen, T. G., Dobrev, D., and Schaumburg, E. (2012). Jump-robust volatility estimation using nearest neighbor truncation. \emph{Journal of Econometrics}, 169, 75-93.

Barndorff-Nielsen, O. E. (2002). Econometric analysis of realized volatility and its use in estimating stochastic volatility models. \emph{Journal of the Royal Statistical Society: Series B (Statistical Methodology)}, 64, 253-280.
}
\author{
Giang Nguyen, Jonathan Cornelissen and Kris Boudt
}
\keyword{IVinference}
\keyword{highfrequency}
