% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jumpTests.R
\name{intradayJumpTest}
\alias{intradayJumpTest}
\title{Intraday jump tests}
\usage{
intradayJumpTest(
  pData,
  volEstimator = "RM",
  driftEstimator = "none",
  alpha = 0.95,
  alignBy = "minutes",
  alignPeriod = 5,
  marketOpen = "09:30:00",
  marketClose = "16:00:00",
  tz = NULL,
  ...
)
}
\arguments{
\item{pData}{\code{xts}or data.table of the price data in levels. This data can (and should in some cases) be tick-level data. The data can span more than one day.}

\item{volEstimator}{character denoting which volatility estimator to use for the tests. See \code{\link{spotVol}}. Default = \code{"RM"} denoting realized measures.}

\item{driftEstimator}{character denoting which drift estimator to use for the tests. See \code{\link{spotDrift}}. Default = \code{"none"} denoting no drift estimation.}

\item{alpha}{numeric of length one determining what confidence level to use when constructing the critical values.}

\item{alignBy}{string indicating the time scale in which \code{alignPeriod} is expressed.
Possible values are: \code{"secs", "seconds", "mins", "minutes", "hours"}.}

\item{alignPeriod}{positive numeric, indicating the number of periods to aggregate over. E.g. to aggregate
based on a 5 minute frequency, set \code{alignPeriod} to 5 and \code{alignBy} to "minutes".
\code{alignPeriod = 5} and \code{alignBy = "minutes"}.}

\item{marketOpen}{the market opening time. This should be in the time zone
specified by \code{tz}. By default, \code{marketOpen = "09:30:00"}.}

\item{marketClose}{the market closing time. This should be in the time zone
specified by \code{tz}. By default, \code{marketClose = "16:00:00"}.}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. We attempt to extract the timezone from the DT column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}}

\item{...}{extra arguments passed on to \code{\link{spotVol}} for the volatility estimation, and to \code{\link{spotDrift}}.

The null hypothesis of the tests in this function is that there are no jumps in the price series}
}
\description{
This function can be used to  test for jumps in intraday price paths.

The tests are of the form \eqn{L(t) = (R(t) - mu(t))/sigma(t)}.

See \code{\link{spotVol}} and \code{\link{spotDrift}} for Estimators for \eqn{\sigma(t)} and \eqn{\mu(t)}, respectively.
}
\examples{
\dontrun{
# We can easily make a Lee-Mykland jump test.
LMtest <- intradayJumpTest(pData = sampleTData[, list(DT, PRICE)], 
                           volEstimator = "RM", driftEstimator = "none",
                           RM = "bipower", lookBackPeriod = 20,
                           alignBy = "minutes", alignPeriod = 5, marketOpen = "09:30:00", 
                           marketClose = "16:00:00")
plot(LMtest)

# We can just as easily use the pre-averaged version from the "Fact or Friction" paper
FoFtest <- intradayJumpTest(pData = sampleTData[, list(DT, PRICE)], 
                            volEstimator = "PARM", driftEstimator = "none",
                            RM = "bipower", lookBackPeriod = 20, theta = 1.2,
                            marketOpen = "09:30:00", marketClose = "16:00:00")
plot(FoFtest)

}
}
\references{
Christensen, K., Oomen, R. C. A., Podolskij, M. (2014): Fact or Friction: Jumps at ultra high frequency. \emph{Journal of Financial Economics}, 144, 576-599
}
\author{
Emil Sjoerup
}
