% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{eval_portfolio_moments}
\alias{eval_portfolio_moments}
\title{Evaluate first four moments of a given portfolio}
\usage{
eval_portfolio_moments(w, X_statistics)
}
\arguments{
\item{w}{Numerical vector with portfolio weights.}

\item{X_statistics}{Argument characterizing the constituents assets. 
Either the sample parameters as obtained by function \code{\link{estimate_sample_moments}()} or
the multivariate skew t parameters as obtained by function \code{\link{estimate_skew_t}()}.}
}
\value{
Four moments of the given portfolio.
}
\description{
Evaluate first four moments of a given portfolio's return, namely,
mean, variance, skewness, and kurtosis.
}
\examples{

library(highOrderPortfolios)
data(X50)

# nonparametric case
X_moments <- estimate_sample_moments(X50[, 1:10])
w_moments <- eval_portfolio_moments(w = rep(1/10, 10), X_statistics = X_moments)

# parametric case (based on the multivariate skew t distribution)
X_skew_t_params <- estimate_skew_t(X50[, 1:10])
w_moments <- eval_portfolio_moments(w = rep(1/10, 10), X_statistics = X_skew_t_params)


}
\references{
R. Zhou and D. P. Palomar, "Solving High-Order Portfolios via Successive Convex Approximation Algorithms," 
in \emph{IEEE Transactions on Signal Processing}, vol. 69, pp. 892-904, 2021.
<doi:10.1109/TSP.2021.3051369>.

X. Wang, R. Zhou, J. Ying, and D. P. Palomar, "Efficient and Scalable High-Order Portfolios Design via Parametric Skew-t Distribution," 
Available in arXiv, 2022. <https://arxiv.org/pdf/2206.02412v1.pdf>.
}
\author{
Rui Zhou, Xiwen Wang, and Daniel P. Palomar
}
