% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scavenge.R
\name{find_hex}
\alias{find_hex}
\title{Finds hex logos for given packages}
\usage{
find_hex(
  pkg_names,
  output = NULL,
  repo = NULL,
  skip_known_logos = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{pkg_names}{A single string or a vector of strings with the names of
packages to find hexes for.}

\item{output}{the output path where to store the found logos}

\item{repo}{The repo to use to find the package logo. If none is
provided, it will try to find one based on CRAN meta information.
Useful when we want to minimize API calls to CRAN.}

\item{skip_known_logos}{Some logos are sourced from known repos or urls.
If set to TRUE, those locations will be skipped. Useful if you are getting
outdated versions of logos, but slower. Defaults to FALSE.}

\item{overwrite}{If a logo with the package name already exists in the
output folder, should it be overwritten. Defaults to FALSE.}
}
\value{
No return, called for side effects.
}
\description{
Finds and downloads the best possible image that represents a hex logo for
a given list of package names.
}
\keyword{external}
\keyword{finder}
