% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_latlon_data.R
\name{download_latlon_data}
\alias{download_latlon_data}
\title{Download latitude longitude data by address}
\usage{
download_latlon_data(
  .ste = c("NSW", "VIC", "QLD", "SA", "WA", "TAS", "NT", "ACT", "OT"),
  data_dir = getOption("healthyAddress.data_dir"),
  repo = "https://github.com/HughParsonage/PSMA-202311",
  overwrite = NA
)
}
\arguments{
\item{.ste}{The jurisdiction to download. Default is to download all.}

\item{data_dir}{The directory for \code{healthyAddress}. Data will be downloaded into a
subdirector \code{latlon} thereof.}

\item{repo}{The repository from which data will be downloaded. Currently only the default is supported,
and \code{"https://github.com/HughParsonage/PSMA-202405"} are supported.}

\item{overwrite}{\code{logical(1)} Applicable only if the file already exists
prior to invoking the function. If \code{FALSE}, an error is raised. If \code{NA},
the default, the file is returned, with a message. Set to \code{TRUE} if you wish to
overwrite the files (possibly having changed \code{repo} to reflect updated data).}
}
\value{
Called for its side effect (downloading the files), but returns the files downloaded.
}
\description{
Download latitude longitude data by address
}
