% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scrape_data.R
\name{scrape_one_group}
\alias{scrape_one_group}
\title{Scrape one group}
\usage{
scrape_one_group(group_url, random_post_number = NULL,
  random_seed = NULL, ...)
}
\arguments{
\item{group_url}{URL to the page to scrape.}

\item{random_post_number}{The number of random posts to scrape. Default is NULL, which means scrape the total number of posts.}

\item{random_seed}{A random number used to set the random seed to reproduce the work.}

\item{...}{optional arguments to FUN.}
}
\value{
A data frame
}
\description{
Get all the posts containing all the replies to those posts from one group by entering its url.
}
\examples{
\donttest{
## get the data of 5 random posts from the group "Angiotensin II Receptor Blockers"
group_url = "https://patient.info/forums/discuss/browse/angiotensin-ii-receptor-blockers-3037"
scrape_one_group(group_url = group_url, random_post_number = 5)
}

}
