% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01-hdnom-models.R
\name{predict.hdcox.model}
\alias{predict.hdcox.model}
\title{Make Predictions from High-Dimensional Cox Models}
\usage{
\method{predict}{hdcox.model}(object, x, y, newx, pred.at, ...)
}
\arguments{
\item{object}{Model object fitted by \code{hdcox.*()} functions.}

\item{x}{Data matrix used to fit the model.}

\item{y}{Response matrix made with \code{\link[survival]{Surv}}.}

\item{newx}{Matrix (with named columns) of new values for \code{x}
at which predictions are to be made.}

\item{pred.at}{Time point at which prediction should take place.}

\item{...}{Other parameters (not used).}
}
\value{
A \code{nrow(newx) x length(pred.at)} matrix containing
overall survival probablity.
}
\description{
Predict overall survival probability at certain time points
from established Cox models.
}
\examples{
library("survival")

# Load imputed SMART data
data("smart")
x = as.matrix(smart[, -c(1, 2)])
time = smart$TEVENT
event = smart$EVENT
y = Surv(time, event)

fit = hdcox.lasso(x, y, nfolds = 5, rule = "lambda.1se", seed = 11)
predict(fit, x, y, newx = x[101:105, ], pred.at = 1:10 * 365)
}
