% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api.R
\name{splitlong_to_cell}
\alias{splitlong_to_cell}
\title{Split long to H3 cell}
\usage{
splitlong_to_cell(split_lower = NULL, split_upper = NULL, simple = TRUE)
}
\arguments{
\item{split_lower}{Integer; Lower 32 bits of an H3 index.}

\item{split_upper}{Integer; Upper 32 bits of an H3 index.}

\item{simple}{Logical; whether to return a vector or a data frame containing
both inputs and outputs.}
}
\value{
Vector of H3 addresses, one for each split long pair supplied.
}
\description{
Convert a "split long" - a pair of 32-bit integers - into an H3 cell index.
}
\examples{
x <- cell_to_splitlong(h3_address = '8abe8d12acaffff')

splitlong_to_cell(split_lower = x[[1]][1], split_upper = x[[1]][2])
}
