% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/h3_algorithms.R
\name{get_kring_list}
\alias{get_kring_list}
\title{Get nearby H3 cell indexes separated by distance}
\usage{
get_kring_list(h3_address = NULL, ring_size = 1, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character cell index generated by H3.}

\item{ring_size}{Character; number of steps away from the central cell.
Defaults to 1.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, a list of length(h3_address). Each list element contains
  a list of `length(ring_size + 1)`. Each of those lists contains a character
  vector of H3 cell indices belonging to that step away from the input cell.
}
\description{
This function returns all the H3 cell indexes within a specified number of steps
from the address supplied, grouped by step.
}
\note{
In total, the number of indices returned for each input cell conforms
  to the
  \href{https://en.wikipedia.org/wiki/Centered_hexagonal_number}{centered
  hexagonal number sequence}, so at
  `ring_size = 5`, 91 cells are returned. Cells are returned in
  separate lists, one for each step.
}
\examples{
# What are the nested neighbours of this cell within two steps?
get_kring_list(h3_address = '86be8d12fffffff', ring_size = 2)
}
