% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_api.R
\name{get_faces}
\alias{get_faces}
\title{get the icosahedron faces of an H3 cell index}
\usage{
get_faces(h3_address = NULL, simple = TRUE)
}
\arguments{
\item{h3_address}{Character; 15-character index generated by H3.}

\item{simple}{Logical; whether to return a vector of outputs or a data frame
containing both inputs and outputs.}
}
\value{
By default, an integer vector of length(h3_address), ranging from 1
  to 20. If `simple = FALSE`, a data.frame with a column of H3 cell indexes and
  a list-column of faces.
}
\description{
This function returns the indices of all icosahedron faces intersected by a
given H3 cell index.
}
\examples{
# Which faces does this h3 cell index intersect?
get_faces(h3_address = '8abe8d12acaffff')
}
